<?php
    require_once "../include/load.php";
    $db->title = 'ES | Production Executives';
    $pagecode = 'p_u';
    include "../include/header.php";
    $tcode = $db -> tcode;
    $userid = $db->user_id;
    $roleid = $db->role_id;
    if(!$roleid==8 && !$roleid==9 && !$roleid==10 && !$db -> admin){
        echo 'File not Found!';
        die();
    }
    
?>
<body>
    <?php include('../include/aside.php'); ?>

    <div class="main_content w-100">
        <div class="container-fluid">
            
            <?php include('../include/top.php')?>
           
            <div class="row">
                <div class="col-xl-8 col-lg-8 col-md-12 col-sm-12 offset-xl-2 offset-lg-1">
                    <div class="dash_head_tabs w-100 mt-3 text-center">
                      <ul class="nav nav-tabs d-flex border-0" id="myTab" role="tablist">
                          <?php 
                            if($db->admin){
                                $teams = 'all';
                            }else{
                                $teams = $tcode ;
                            }
                          ?>
                            <!--<li class="nav-item flex-fill" role="presentation">-->
                            <!--    <a class="nav-link active" id="allteam-tab" data-toggle="tab" href="#allleads" onclick="filter('<?=$teams?>')" role="tab" aria-controls="allleads" aria-selected="true">All Teams</a>-->
                            <!--</li>-->
                            <?php
                            if(!$db -> admin ){
                                $team = "WHERE team = '$tcode'";    
                            }
                            
                            $teamquery = $db->qu->query("SELECT group_name , fk_p_id , team  FROM `groups`  $team");
                            while($team_res = mysqli_fetch_array($teamquery)){ 
                            
                                $teamname = $team_res['group_name'];
                            
                            ?>
                            <li class="nav-item flex-fill" role="presentation">
                                <a class="nav-link " id="allteam-tab" data-toggle="tab" href="#allleads" onclick="filter('<?=$team_res['team']?>')" role="tab" aria-controls="allleads" aria-selected="true"><?=$teamname?></a>
                            </li>
                    <?php } ; ?>

                        </ul>
                    </div>
                </div>
            </div>
            
            <?php if($roleid == 9 || $db->admin ){ 
                if($roleid == 9){ 
            
                    $condition = ' AND lgp.am_id = '.$userid; 
                    
                } 
            ?>
            <div class="row">
                <div class="tab-content w-100 mt-3" id="myTabContent">
                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                        <form class="mt-3 p-3 shadow-sm table_filtr">
                            <div class="row">
                                <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12">
                                    <div class="form-group mb-lg-0">
                                        <label>Team Co ordinators</label>
                                        
                                     <select class="form-control shadow-sm p-3" id="tcname" name="tcname" onchange="filter()">
                                        <option value='all'>Select TC</option>
                                        <?php
                                        $all_tc_query = $db->qu->query("SELECT iup.fk_parent_id, iup.first_name, iup.last_name
                                        FROM in_user_profile as iup
                                        INNER JOIN in_users as U ON U.id = iup.fk_parent_id
                                        INNER JOIN lead_group_p as lgp ON lgp.tc_id = iup.fk_parent_id
                                        WHERE iup.role_id = '10'
                                        $condition
                                        AND U.is_active = '1' GROUP BY iup.fk_parent_id ORDER BY iup.first_name asc");
                                        while($tc_res = mysqli_fetch_array($all_tc_query)){
                                        ?>
                                        <option value="<?=$tc_res['fk_parent_id']?>"> <?=$tc_res['first_name']." ".$tc_res['last_name']?></option>
                                        <?php }; ?>
                                     </select>
                                     </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php  }; ?>
                
                    <div class="tab-pane fade show active" id="allleads" role="tabpanel" aria-labelledby="allleads">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-md-12">
                            <div class="card shadow-sm border-0 mb-4 innr_pge_card mt-3">
                                <div class="card-header border-0 text-white pt-3 pb-3">
                                    <h5 class="text-uppercase font-weight-bold">Production Executives</h5>
                                </div>
                                <div class="card-body table-responsive">
                                    <table id="data-table" class="table table-bordered table-striped table-hide-first-column" style="width: 100%;">
                                        <thead>
                                            <tr>
                                            <th>S.No</th>
                                            <th>Writer Name</th>
                                            <th>Team</th>
                                            <th>TC Name</th>
                                            <th>AM Name</th>
                                            <th>PM Name</th>
                                            <?php if($roleid == 8 || $roleid == 9 || $db->admin ){ ?>
                                            <th>Action</th>
                                            <?php } ?>
                                            
                                            </tr>
                                        </thead>
                                        <tbody>

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>

    <?php include('../include/footer.php'); ?>


    <script>
        $(function() {
            if('<?=$teams?>' != 'all'){
                filter('<?=$teams;?>');
            }
        })

        function filter(id) {
            var tcname = $("#tcname").val();
            var table = $('#data-table').DataTable();
            table.destroy();
            $('#data-table').dataTable({
                "select": {
                    style: 'multi'
                },
                'processing': true,
                'serverSide': true,
                'serverMethod': 'post',
                "pageLength":10,
                //"pagingType": "simple",
                "lengthMenu": [ 10, 25, 50, 75],
                "bPaginate":true,
                "searching":true,
                "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {},
                "columnDefs": [
                ],
                "ajax": {
                    url: "response.php",
                    type: "post",
                    data: {'team':id, 'tcname': tcname},
                    error: function(e) {
                        $("#employee_grid_processing").css("display", "none");
                        console.log(e)
                    }
                }
            });

        }

        function show_action(id,teamcode){
            data = {
                action: 'show_action',
                id:id,
                teamcode:teamcode
            }
            action('Action',data,'','')
        }


// |------FORM SUBMIT FUNCTIONS------|


function change_tc(current_writer_id, tc_id){
    var data = $("#tc_assign_form").serializeArray();
        data.push({ name: "action", value: "change_tc" });
        data.push({ name: "wid", value: current_writer_id });
        data.push({ name: "old_tc_id", value: tc_id });
        submit(data);
}

function change_am(tc_id, am_id){
    var data = $("#am_assign_form").serializeArray();
        data.push({ name: "action", value: "change_am" });
        data.push({ name: "old_tc_id", value: tc_id });
        data.push({ name: "old_am_id", value: am_id });
        submit(data);
}



//// MAIN ACTION FUNCTION:
function action(header, data, btn, clicks){
            var data = data;
            $.ajax({
                url: 'action.php',
                // url: 'action-old.php',
                type: 'POST',
                data: data,
                success: function(res){
                modals(header, res, btn, clicks);
                },
                error: function(e){
                console.log('Ajax Error' + e)
                }
            })
        }

function submit(data){
            $.ajax({
                url: 'forms_submit.php',
                type:'post',
                data: data,
                success:function(response){
                      console.log(response);
                    var result = $.parseJSON(response);
                    if(result[0] == 1){
                        swal("Successfully!", result[1], "success");
                        $('#data-table').DataTable().ajax.reload();
                        $("#myModal").modal('toggle');
                    } else{
                        swal("Error!", result[1], "error");
                    }
                }
            });
    }




    </script>
</body>

</html>