<?php include "../include/load.php";

    $db->title = 'ES | Payments table';
    
    $pagecode = 'p_p_m';
    
    if(!$db -> pageCode($pagecode)){
        echo 'File Not found!';
        die();
    }
    
     //$db -> payment_get();    
    
?>

<!DOCTYPE html>
<html>

<?php

 include "../include/header.php";

 ?>


<body class="noselect">
    
<?php include('../include/aside.php'); ?>

<div class="main_content w-100">
  <div class="container-fluid">
      <div class="row">
                <div class="col-xl-6">
                    <ul class="dash_head_left mb-3 mt-3 w-100">
                        <li class="nav-item active d-inline-block list-unstyled"> 
                            <span class="nav-link border rounded bg-white shadow-sm font-weight-bold es-label"><?=$db->role_name.' - '.$db->title ?></span> 
                        </li>
                        <li class="nav-item d-inline-block list-unstyled"> <span class="nav-link">Details of
                                <strong>AUGUST-2020</strong> Only </span>
                        <li class="nav-item list-unstyled d-inline-block"></li>
                        </li>
                        <li class="nav-item active d-inline-block list-unstyled">
                            <div class="spinner-border spinner-border-sm text-primary" style='display : none'
                                id='loader' role="status">
                                <span class="sr-only">Loading...</span>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
      <div class="row">
        <div class="col-xl-6 col-lg-6 col-md-12 col-sm-12 offset-xl-3 offset-lg-3">
          <div class="dash_head_tabs w-100 mt-3 text-center">
              <input type="hidden" value='all' id='table' /> 
            <ul class="nav nav-tabs d-flex border-0" id="myTab" role="tablist">
             
                <?php
                    $active = '';
                if($db->team_code == 'all'){ ?>
                <li class="nav-item flex-fill" onclick="tab('all')" role="presentation">
                    <a class="nav-link active" id="allteam-tab" data-toggle="tab" href="#allleads"
                        role="tab" aria-controls="allleads" aria-selected="true">All payments</a>
                </li>
                <?php
                }else{
                    $active = 'active';
                };
                    $teams = $db->getTeam();
                    while($row = mysqli_fetch_array($teams)){
                ?>
                    <li class="nav-item flex-fill" role="presentation">
                        <a class="nav-link <?=$active;?>" id="teamb-tab" onclick="tab('<?=$row['code'];?>')" data-toggle="tab" href="#allleads" role="tab" aria-controls="allleads" aria-selected="false"><?php echo $row['name'] ?> payments</a>
                    </li>
                <?php  }; ?>
            </ul>
          </div>
        </div>
      </div>
      <div class="row">
      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
              <div class="mt-3 p-3 shadow-sm table_filtr">
                <div class="row">
                  <div class="co-xl-4 col-lg-4 col-md-4 col-sm-12">
                      <?php if($role_id == 2){ ?>
                    <div class="form-group mb-lg-0">
                        <a type="button" href='duplicates' target="_blank" class="btn-shadow cb cb1 btn btn-primary btn-sm p-3 btn-block font-weight-bold text-uppercase">Duplicate Payment</a>
                    </div>
                    <?php } ?>
                  </div>
                  <div class="co-xl-4 col-lg-4 col-md-4 col-sm-12">
                    <div class="form-group mb-lg-0">
                        <button type="button" class="btn-shadow cb cb2 btn btn-primary btn-sm p-3 btn-block font-weight-bold text-uppercase">Disputed Payment</button>
                    </div>
                  </div>
                  <div class="co-xl-4 col-lg-4 col-md-4 col-sm-12">
                    <div class="form-group mb-lg-0">
                        <button type="button" class="btn-shadow cb cb3 btn btn-primary btn-sm p-3 btn-block font-weight-bold text-uppercase">Refunded Payment</button>
                    </div>
                  </div>
                </div>
               </div>
            </div>   
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
              <div class="mt-3 p-3 shadow-sm table_filtr">
                <div class="row custom-center" >
                  <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12">
                    <div class="form-group mb-lg-0">
                        <input placeholder="Start Date" type="date" id="sdate" onchange="filter()" class="form-control shadow-sm p-3">
                    </div>
                  </div>
                  <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12">
                    <div class="form-group mb-lg-0">
                         <input placeholder="End Date" type="date" id="edate" onchange="filter()" class="form-control shadow-sm p-3">
                    </div>
                  </div>
                  <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12">
                    <div class="form-group mb-lg-0">
                       <select class="form-control shadow-sm p-3" id="user_id" onchange="filter()">
                          <option value="all" >Select User</option>
                          <?php
                            $userqu= $db->getUsersS();
                            while($userfetch = mysqli_fetch_array($userqu)){?>
                                <option value="<?=$userfetch['id'] ?>"><?=$userfetch['first_name']." - ".$userfetch['last_name']." { ".$userfetch['team'].' }' ?></option>
                            
                            <?php };?>
                          </select>
                    </div>
                  </div>
                  
                         
                  <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12">
                    <div class="form-group mb-lg-0">
                        <select class="form-control shadow-sm p-3" name='website_id' id='website_id' onchange="filter()">
                            <option value='all' >Select Website</option>
                            <?php 
                                $team =  $db->team_code;
                                $fetchWeb = $db->getWebsites($team);
                                
                                while($row = mysqli_fetch_array($fetchWeb)){
                                    if($row['status'] == 1){  
                                        $url = ltrim($row['url'],"www."); 
                                        $id = $row['id'];
                                        $name = $url.' - Team '.$row['team'];
                                        
                                        echo "<option value='$id'>$name</option>";                                   
                                    }
                                }
                            ?>
                        </select> 
                    </div>
                  </div>

                  <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12">
                    <div class="form-group mb-lg-0">
                        <select class="form-control shadow-sm p-3" name='status_id' id='status_id' onchange="filter()">
                            <option value='all' >Select Status</option>
                            <option value=0>Received</option>
                            <option value=1>Not Received</option>
        
                        </select> 
                    </div>
                  </div>
                  <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12">
                    <div class="form-group mb-lg-0" id="exportToExcelDiv">
                      <button type="button" id="exportToExcel" class="btn-shadow btn btn-primary btn-sm p-3 btn-block">Export To Excel</button>
                    </div>
                  </div>
                </div>
              </div>
            </div> 

        <div class="tab-content w-100 mt-3" id="myTabContent">
          <div class="tab-pane fade show active" id="allleads" role="tabpanel" aria-labelledby="allleads">     
            <div class="col-xl-12 col-lg-12 col-md-12 col-md-12">        
              <div class="card shadow-sm border-0 mb-4 innr_pge_card mt-3">
                <div class="card-header border-0 text-white pt-3 pb-3">
                  <h5 class="text-uppercase font-weight-bold" id='tabhead'>Payment Table</h5>
                </div>
                <div class="card-body table-responsive">
                  <table id="data-table" class="table table-bordered table-striped wid ">
                    <thead class=''>
                        <tr >
                            <th>#</th>
                            <th>Invoice No.</th>
                            <th>Customer Info</th>
                            <th>Payment Date</th>
                            <th>Invoice Date</th>
                            <th>Amount</th>
                            <th>Stripe Amount</th>
                            <th>Customer ID</th>
                            <th>Transaction ID</th>
                            <th>Payment Mode</th>
                            <th>Create By</th>
                            <th>Team</th>
                            <th>Website</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        
                    </tbody>                                   
                  </table>
                </div>
              </div>
            </div>
          </div>
  
        </div>
    </div>
  </div>
</div>


<?php include('../include/footer.php'); ?>


<script>

    $(function(){
       
        
        $.ajax({
            url :"assoc_response_bkp.php",
            type: "post",
            data:{'action' : 'action' },
            success : function(res){
                console.log(res)
            }
        })
    
        tab('<?=$db->team_code?>');
        exportButton();
        
    })
    
    function tab(val){
      $('#table').val(val);
       $('#tabhead').html(' Team '+val+' Payment table ')
      filter();
    }


    function filter(){
          
        var sdate = $("#sdate").val();
        var edate = $("#edate").val();
        var table = $('#table').val();
        var users = $('#user_id').val();
        var website =$('#website_id').val();
        var statusid =$('#status_id').val();
        var tables = $('#data-table').DataTable();
        
        var width = $(window).width();
        
        tables.destroy();
         $('#data-table').dataTable({
            dom: 'lBfrtip',

            // If You Want pdf and copy button uncomment this
            // buttons: [
            //     'copyHtml5',
            //     'csvHtml5',
            //     'pdfHtml5'
            // ],

            buttons: [
                'csvHtml5',
            ],
            lengthMenu:[
              [10,25,50,100],
              [10,25,50 , 100]
            ],
            "responsive" : width > 767 ? false : {
              details: {
                type: 'column',
                target: 'tr'
                }
            },
             
            "bProcessing": true,
                "serverSide": true,
                "select": {
                    style: 'multi'
                },
            "order": [ 3, "desc" ],
            "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
               
                    
                
               
            },
            
            
            "columnDefs": [  
               
              {
                  className: 'sorting_1 dtr-control ',
                  orderable: false,
                  targets:   'tr'
              }
            
            ],
            
            "ajax":{
                url :"assoc_response_bkp.php",
                type: "post",
                data:{'team' : table , 'website':website, 'statusid':statusid, 'users':users,  'sdate' : sdate , 'edate' : edate},
                error: function(){
                    $("#employee_grid_processing").css("display","none !important");
                    
                }
            }
            
        });
       
    }
    
  
    function edit(id){
      data = {action : 'EditAssoc' , id : id }
      action('EditAssoc',data , '' ,'')
    }

    function paymove(id, addedby){
      data = {action : 'paymove',
            id : id,
            addedby: addedby
            }
      action('Payment Move',data , '' ,'')
    }
    
    function view(id){
      data = {action : 'paymentslogs' , id : id }
      action('Detail',data , '' , '')
    }

    function info(invid , pid ){
      data = {action : 'customerinfo' , id : invid , pid : pid }
      action('Customer Info',data , '' , '')
    }

 

    function deleted(id){
      
      swal({
        title: "Are you sure?",
        text: "Once deleted, you will not be able to recover this imaginary file!",
        icon: "warning",
        buttons: true,
        dangerMode: true,
      })
      .then((willDelete) => {
        if (willDelete) {
          data = {action : 'delete' , id : id }
          action('Delete Payments',data , '' , '')
        } else {
          swal("Your imaginary file is safe!");
        }
      });
      
    }
    
        function support_payment_action(id){
            var id = id;
            var main_amount = $("#main_amount").val();
            $.ajax({
              url:'get_ass_payment_receipt.php',
              type:'post',
              data:{'id':id,'main_amount':main_amount},
              success:function(response){
                alert(response);
                }
            });
        }
    
    
    function action(header,data , btn , clicks){
      var data = data;
      console.log(data);
      
      $.ajax({
        url : 'assocc_action.php',
        type : 'POST',
        data : data,
        success : function(res){
          if(header == 'Delete Payments'){
              swal(res);
              $('#data-table').DataTable().ajax.reload(); 
          }else{
            modals(header,res,btn,clicks);
          }
        },
        error : function(e){
          console.log('Ajax Error'+e)
        }
      })
    }
    
    $(window).resize(function () { 
        var width = $(window).width();
        console.log(width)
       if(width < 767){
          location.reload(); 
       }
      
    });
    
    function exportButton(){
      var buttonDiv = $('.dt-buttons');
      $('#exportToExcelDiv').html(buttonDiv);
      var buttonExp = $('#exportToExcelDiv button');
      buttonExp.attr('class','btn-shadow btn btn-primary btn-sm p-3 btn-block').html('Export To Excel');
    }  
</script>

</body>
</html>