<?php 
   
    include ("../include/load.php");
    $db->title = 'ES | Invoice table';
?>

<!DOCTYPE html>
<html>

<?php

 include "../include/header.php";

 ?>


<style>
    .selected{
        background-color:#082150 !important;
        color:white;
    }
</style>
<body>
    
    <?php include('../include/aside.php'); ?>

    <div class="main_content w-100">
      <div class="container-fluid">
        <div class="row">
            <div class="col-xl-6">
                <ul class="dash_head_left mb-3 mt-3 w-100">
                  <li class="nav-item active d-inline-block list-unstyled"> <span class="nav-link border rounded bg-white shadow-sm font-weight-bold">Admin Dashboard</span> </li>
                  <li class="nav-item d-inline-block list-unstyled"> <span class="nav-link">Details of <strong>AUGUST-2020</strong> Only <a class="btn btn-primary btn-sm ml-3" onClick="test()"><i class="icofont-refresh"></i></a></span><li class="nav-item list-unstyled d-inline-block"></li>
                  </li>
                  <li class="nav-item active d-inline-block list-unstyled">
                    <div class="spinner-border spinner-border-sm text-primary" style='display : none' id='loader' role="status">
                      <span class="sr-only">Loading...</span>
                    </div>
                  </li>
                </ul>
            </div>
        </div>
        <div class="row">
          <div class="col-xl-6 col-lg-6 col-md-12 col-sm-12 offset-xl-3 offset-lg-3">
            <div class="dash_head_tabs w-100 mt-3 text-center">
              <input type="hidden" value='all' id='table' /> 
              <ul class="nav nav-tabs d-flex border-0" id="myTab" role="tablist">
                <li class="nav-item flex-fill" role="presentation">
                    <a class="nav-link active" id="allteam-tab" onclick="tab('all')" data-toggle="tab" href="#allleads" role="tab" aria-controls="allleads" aria-selected="true">All Invoices</a>
                </li>
                <?php
                    $teams = $db->qu->query('select * from team');
                    while($row = mysqli_fetch_array($teams)){
                ?>
                
                <li class="nav-item flex-fill" role="presentation">
                  <a class="nav-link" id="teamb-tab" onclick="tab('<?=$row['code'];?>')" data-toggle="tab" href="#allleads" role="tab" aria-controls="allleads" aria-selected="false"><?php echo $row['name'] ?> Invoices</a>
                </li>

                <?php  
                    }
            ?>
              </ul>
            </div>
          </div>
        </div>
          <div class="row">
            <div class="tab-content w-100 mt-3" id="myTabContent">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                  <form class="mt-3 p-3 shadow-sm table_filtr">
                    <div class="row custom-center">
                      <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12 ">
                        <div class="form-group mb-lg-0">
                          <select class="form-control shadow-sm p-3" id="website_id" onchange="filter()">
                          <option value="all" >Select Website</option>
                          <?php
                          $websitequ = $db->getWebsites();
                             while($webfetch = mysqli_fetch_array($websitequ)){

                              $weburl = str_replace("www.","",$webfetch['url']); 
                          ?>
                            <option value="<?=$webfetch['id'] ?>"><?=$weburl." - Team-".$webfetch['team'] ?></option>
                            
                            <?php
                             };
                             ?>
                          </select>
                        </div>
                      </div>
                      <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12">
                        <div class="form-group mb-lg-0">
                         <select class="form-control shadow-sm p-3" id="user_id" onchange="filter()">
                          <option value="all" >Select User</option>
                          <?php
                          $userqu= $db->getUsersS();
                             while($userfetch = mysqli_fetch_array($userqu)){
                          ?>
                            <option value="<?=$userfetch['id'] ?>"><?=$userfetch['first_name']." - ".$userfetch['last_name']." { ".$userfetch['team'].' }' ?></option>
                            
                            <?php
                             };
                             ?>
                          </select>
                        </div>
                      </div>
                      <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12">
                        <div class="form-group mb-lg-0">
                          <select class="form-control shadow-sm p-3" id="status_id" onchange="filter()">
                          <option value="all" >Select Status</option>
                            <option value="1">Paid</option>
                            <option value="0">Unpaid</option>
                          </select>
                        </div>
                      </div>
                      <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12">
                        <div class="form-group mb-lg-0">
                          <input type="date" id="sdate" class="form-control shadow-sm p-3" onchange="filter()" placeholder="Start Date">
                        </div>
                      </div>
                      <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12">
                        <div class="form-group mb-lg-0">
                          <input type="date" id="edate" class="form-control shadow-sm p-3" onchange="filter()" placeholder="End Date">
                        </div>
                      </div>
                      <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12">
                          <div class="form-group mb-lg-0">
                              <button id="delete_button" type="button" class="btn btn-danger btn-sm p-3 btn-block">Delete Selected Invoice</button>
                          </div>
                       </div>
                    </div>
                  </form>
                </div> 
              <div class="tab-pane fade show active" id="allleads" role="tabpanel" aria-labelledby="allleads">     
                <div class="col-xl-12 col-lg-12 col-md-12 col-md-12">        
                  <div class="card shadow-sm border-0 mb-4 innr_pge_card mt-3">
                    <div class="card-header border-0 text-white pt-3 pb-3">
                      <h5 class="text-uppercase font-weight-bold">Invoices</h5>
                    </div>
                    <div class="card-body table-responsive">
                      <table id="data-table" class="table table-bordered table-striped no-wrap w-100" >
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Invoice No</th>
                                <th>Lead Code</th>
                                <th>Created Date</th>
                                <th>Amount</th>
                                <th>Created By</th>
                                <th>Status</th>
                                <th>Website</th>
                                <th>Team</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
      
                        </tbody>                                   
                      </table>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

<?php include('../include/footer.php'); ?>
    <script>
    $(function(){
        var invoicenumbers = [];
        $("body").addClass("noselect");
        $("body").on("contextmenu",function(e){
        return false;
            });
           

     $('#data-table tbody').on( 'click', 'tr', function () {
        $(this).toggleClass('selected');
        $(".selected td:nth-child(1)").addClass("selection");
        $(".selected input[type='checkbox']:checked");
      });

        
        tab('all');  
        // mobile_menu();
     
    })



    function tab(val){
      $('#table').val(val);
      $('#data-table tbody').html('');
      var datatable = $('#data-table').DataTable();
        datatable.destroy();
        setTimeout(function(){filter()}, 1000)
    }


    function filter(){
          
        var sdate = $("#sdate").val();
        var edate = $("#edate").val();
        var table = $('#table').val();
        var users = $('#user_id').val();
        var website =$('#website_id').val();
        var status = $('#status_id').val();
        
         $('#data-table').DataTable().destroy();
         
         $('#data-table').dataTable({
            "bProcessing": true,
            responsive: {
              details: {
                type: 'column',
                target: 'tr'
                }
            },
            "select": {
                style: 'multi'
            },
          
            "columnDefs": [{
              
              className: 'sorting_1 dtr-control',
              orderable: false,
              targets:   1
            }],
            
            
            "pageLength": 10,
            "serverSide": true,
            "pagenation" : true,
            "lengthMenu": [[10, 25, 50, 100], [10, 25, 50, 100]],
            "order": [ 0, "desc" ],
      
            "ajax":{
                url :"response.php",
                type: "post",
                data:{'table' : table, 'website':website,'users':users,  'sdate' : sdate , 'edate' : edate,'status' : status  },
                error: function(){
                    $("#employee_grid_processing").css("display","none");
                }
            } 
        });
        
    }
    
    function edit(id){
      data = {action : 'edit' , id : id }
      action('Action',data , '' ,'')
    }
        
    function view(id){
      data = {action : 'view' , id : id }
      action('Detail',data , '' , '')
    }
    
    function history(id){
      data = {action : 'history' , id : id }
      action('History',data , '' , '')
    }
    
    function info(id){
      data = {action : 'paymentslogs' , id : id }
      action('Detail',data , '' , '')
    }

 


    function deleted(id){
      
      swal({
        title: "Are you sure?",
        text: "Once deleted, you will not be able to recover this imaginary file!",
        icon: "warning",
        buttons: true,
        dangerMode: true,
      })
      .then((willDelete) => {
        if (willDelete) {
          data = {action : 'delete' , id : id }
          action('Delete Payments',data , '' , '')
        } else {
          swal("Your imaginary file is safe!");
        }
      });
      
    }
    function action(header, data , btn, clicks){
      var data = data;
      $.ajax({
        url:"action.php",
        type:"POST",
        data:data,
        success:function(res){
          modals(header,res,btn,clicks);
        },
        error:function(error){
          console.log(error);
        }
      })
    }
    
     $('#delete_button').click(function(){
         console.log('delete button');
        invoicenumbers = [];
        // $. each($(" .selected input"), function(){
        $.each($("table .selected input"), function(){
        invoicenumbers.push($(this).val());
        });
          console.log(invoicenumbers);
        swal({
        title: "Are you sure?",
        text: "Once deleted, you will not be able to recover this imaginary file! "+invoicenumbers,
        icon: "warning",
        buttons: true,
        dangerMode: true,
      })
      .then((willDelete) => {
        if (willDelete) {
   
            //alert(lead_codes);
       $.ajax({
                url:'delete_multiple_invoices.php',
                type:'post',
                data:{'invoicenumbers':invoicenumbers},
                success:function(response){
                    swal(response)
                    $('#data-table').DataTable().ajax.reload();
                    
                }
            });
        // "#No_button"
        } else {
             invoicenumbers = [];
            $("tr").removeClass("selected");
         swal("Your imaginary file is safe!");
        }
        });
    });
    </script>
</body>
</html>