<?php 
    require_once "../include/load.php";
    $db->title = 'ES | User table';
    $role_id = $db->role_id;
    $pagecode = 'p_l_m';
    
    if(!$db -> pageCode($pagecode)){
        echo 'File Not found!';
        die();
    }
?>
<!DOCTYPE html>
<html>
<?php
    include "../include/header.php";
?>
<style>
      .selected{
        background-color:#082150 !important;
        color:white !important;
    }
    
    .selected a{
        color:white !important;
    }
    
    .table a {
        color:black ;
    }
</style>

<body class="noselect">
    <?php include('../include/aside.php'); ?>
    <div class="main_content w-100">
        <div class="container-fluid">
           <?php include('../include/top.php'); ?>
            <div class="row">
                <div class="col-xl-6 col-lg-6 col-md-12 col-sm-12 offset-xl-3 offset-lg-3">
                    <div class="dash_head_tabs w-100 mt-3 text-center">
                        <ul class="nav nav-tabs d-flex border-0" id="myTab" role="tablist">
                            <input type="hidden" value='all' id='team' />
                            <?php
                                $active = '';
                            if($db->team_code == 'all'){ ?>
                            <li class="nav-item flex-fill" onclick="tab('all')" role="presentation">
                                <a class="nav-link active" id="allteam-tab" data-toggle="tab" href="#allleads"
                                    role="tab" aria-controls="allleads" aria-selected="true">All Leads</a>
                            </li>
                            <?php
                            }else{
                                $active = 'active';
                            };
                            $teams = $db->getTeam();
                            
                            while($row = mysqli_fetch_array($teams)){
                                ?>
                                
                                <li class="nav-item flex-fill" role="presentation">
                                    <a class="nav-link <?=$active;?>" id="teamb-tab" onclick="tab('<?=$row['code'];?>')" data-toggle="tab" href="#allleads" role="tab" aria-controls="allleads" aria-selected="false"><?php echo $row['name'] ?> Leads</a>
                                </li>
                                
                            <?php  
                                };
                            ?>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="tab-content w-100 mt-3" id="myTabContent">
                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                        <form class="mt-3 p-3 shadow-sm table_filtr ">
                            <div class="row">
                                <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12">
                                    <div class="form-group mb-lg-0">
                                        <select class="form-control shadow-sm p-3" id="status_id" onchange="filter()">
                                            <option value="all">Select Status</option>
                                            <option value=1>Active</option>
                                            <option value=0>Inactive</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12">
                                    <div class="form-group mb-lg-0">
                                        <select class="form-control shadow-sm p-3" id="O_status_id" onchange="filter()">
                                            <option value="all">Out side Status</option>
                                            <option value=1>Out side Active</option>
                                            <option value=0>Out side Inactive</option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12">
                                    <div class="form-group mb-lg-0">
                                        <input type="date" id="sdate" class="form-control shadow-sm p-3"
                                            onchange="filter()" placeholder="Start Date">
                                    </div>
                                </div>
                                
                                <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12 ">
                                    <div class="form-group mb-lg-0">
                                        <select  class="selectpicker form-control"  data-live-search="true" id="realname" onchange="filter()">
                                            <option value="all">Select Real Name</option>
                                    <?php $names = $db->qu->query("select fk_parent_id, first_name, last_name from in_user_name WHERE first_name != '' AND first_name != '0'  ");
                                    while($row = mysqli_fetch_array($names)){ ?>
                                    <option value="<?=$row['fk_parent_id']?>"><?=$row['first_name'].' '.$row['last_name']?></option>
                                    <?php }; ?>
                                        </select>
                                    </div>
                                </div>
                                <?php 
                                if($db -> admin ){ ?>
                                   <!--for admin only-->
                                <!--<div class="co-xl-2 col-lg-2 col-md-6 col-sm-12">-->
                                <!--    <div class="form-group mb-lg-0">-->
                                <!--        <button type="button" onclick='test()' class="btn btn-info btn-sm p-3 btn-block">-->
                                <!--            Reload leads</button>-->
                                <!--    </div>-->
                                <!--</div>-->
                            <?php 
                                }
                            ?>
                                
                            </div>
                            
                            <div class="row mt-3" id='action_1'>
                                <?php    
                                if($db -> admin || $role_id == 19 || $role_id == 20 ){ ?>
                                   <!--for admin and QA only-->
                                
                                <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12">
                                    <div class="form-group mb-lg-0">
                                        <select class="form-control shadow-sm p-3" id="out_side_s" >
                                           <option value='select'>Select Out side </option>
                                           <option value='1'>Out side allow</option>
                                           <option value='0'>Out side block</option>
                                       </select>
                                    </div>
                                </div>
                                <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12">
                                    <div class="form-group mb-lg-0">
                                        <select class="form-control shadow-sm p-3" id="active_s" >
                                           <option value='select' >Select user active</option>
                                           <option value='1' >Active</option>
                                           <option value='0' >Block</option>
                                       </select>
                                    </div>
                                </div>
                                <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12">
                                    <div class="form-group mb-lg-0">
                                        <button type="button" id='delete_button' class="btn btn-success btn-sm p-3 btn-block">Submit</button>
                                    </div>
                                </div>
                                
                            
                            <?php } ?>
                            
                            </div>
                            
                        </form>
                    </div>
                    <div class="tab-pane fade show active" id="allleads" role="tabpanel" aria-labelledby="allleads">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-md-12">
                            <div class="card shadow-sm border-0 mb-4 innr_pge_card mt-3">
                                <div class="card-header border-0 text-white pt-3 pb-3">
                                    <h5 class="text-uppercase font-weight-bold">Leads Table</h5>
                                </div>
                                <div class="card-body table-responsive">
                                    <table id="data-table"
                                        class="table table-bordered table-striped table-hide-first-column"
                                        style="width: 100%;">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Profile Pic</th>
                                                <th>Employee Id</th>
                                                <th>User Name</th>
                                                <th>Full Name</th>
                                                <th>Role </th>
                                                <th>Created By</th>
                                                <th>CREATED AT</th>
                                                <th>Team</th>
                                                <th>Real Name</th>
                                                <th>Extension</th>
                                                <th>Stauts</th>
                                                <th>Access</th>
                                                <th>Action</th>
                                                <th>Login</th>
                                            </tr>
                                        </thead>
                                        <tbody>

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>

    <?php include('../include/footer.php'); ?>

    <script>
        // function test(){
        //     $('#data-table').DataTable().ajax.reload(null, true);
        //     // alert('tset')
        // }

      $(function(){
          
        var lead_codes = [];
        $("body").addClass("noselect");
        $("body").on("contextmenu",function(e){
        return false;
            });
             
             tab('<?=$db->team_code?>');
             
             
     $('#data-table tbody').on( 'click', 'tr', function () {
        $(this).toggleClass('selected');
        $(".selected td:nth-child(1)").addClass("selection");
        $(".selected input[type='checkbox']:checked");
        lead_codes = [];
        leads = [];
        
        $.each($("table .selected input"), function(){
            lead_codes.push($(this).val());
            leads.push($(this).data("leadcode"));
            console.log();
        });
        console.log(lead_codes)
      });

   
     $('#delete_button').click(function(){
        lead_codes = [];
        leads = [];
        
        $.each($("table .selected input"), function(){
            lead_codes.push($(this).val());
            leads.push($(this).data("leadcode"));
        });
        
        var outside = $('#out_side_s').val(); 
        var active = $('#active_s').val(); 
       
          swal({
                title: "Are you sure?",
                text: leads+"!",
                icon: "warning",
                buttons: true,
                dangerMode: true,
            })
            .then((willDelete) => {
                if (willDelete) {
                    
                    $.ajax({
                        url:'action1.php',
                        type:'post',
                        data:{'id':lead_codes , action : 'access', active : active , outside : outside },
                        success:function(response){
                            swal("Your imaginary action!")
                            $('#data-table').DataTable().ajax.reload();
                            
                        }
                    });
                } else {
                    swal("Your imaginary Leads is safe!");
                    lead_codes = [];
                    $("tr").removeClass("selected");
                }
            });
        
    });
});
    

    function tab(val) {
        $('#team').val(val);
        filter();
    }
    
    var width = $(window).width();
    function filter() {
        var team = $('#team').val(); //hidden filed
        var users = $('#user_id').val();
        var status = $('#status_id').val();
        var o_status = $('#O_status_id').val();
        var realname = $('#realname').val();
        var datatable = $('#data-table').DataTable();

        datatable.destroy();

        $('#data-table').dataTable({
            "select": {
                style: 'multi'
            },
            "responsive": {
                details: {
                    type: 'column',
                    
                }
            },
            "columnDefs": [ {
                className: 'dtr-control',
                orderable: false,
                targets:   0
            } ],
            "pageLength": 10,
            "serverSide": true,
            "pagenation": true,
            "lengthMenu": [
                [10, 25, 50, 100],
                [10, 25, 50, 100]
            ],
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {},
            "columnDefs": [],

            "ajax": {
                url: "response.php",
                type: "post",
                data: {
                    'team': team,
                    'users': users,
                    'status': status,
                    'realname': realname,
                    'o_status' : o_status
                },
                error: function() {
                    $("#employee_grid_processing").css("display", "none");
                }
            }
        });

    }

    function edit(id) {
        data = {
            action: 'edit',
            id: id
        }
        action('Edit Details', data, '', '')
    }

    function view(id) {
        data = {
            action: 'view',
            id: id
        }
        action('More Detail', data, '', '')
    }

       
    function edit_submit(id){
        var data = $("#user-form").serializeArray();
            data.push({ name: "action", value: "edit_submit"});
            data.push({ name: "id", value: id });
            console.log(data);
         submit(data);
    }
    
    function info(id) {
        data = {
            action: 'customerinfo',
            id: id
        }
        action('Customer Info', data, '', '')
    }

    function history(id){
      data = {action : 'history' , id : id }
      action('History',data , '' , '')
    }
    
    function deleted(id) {

        swal({
                title: "Are you sure?",
                text: "Once deleted, you will not be able to recover this imaginary file!",
                icon: "warning",
                buttons: true,
                dangerMode: true,
            })
            .then((willDelete) => {
                if (willDelete) {
                    data = {
                        action: 'delete',
                        id: id
                    }
                    action('Delete Payments', data, '', '')
                } else {
                    swal("Your imaginary file is safe!");
                }
            });

    }

//FUNCTION DEFINES
    function action(header, data, btn, clicks) {
        var data = data;
        $.ajax({
            url: "action1.php",
            type: "POST",
            data: data,
            success: function(res) {
                modals(header, res, btn, clicks);
            },
            error: function(error) {
                console.log(error);
            }
        })
    }
    
function submit(data){
                $.ajax({
                    url: 'form_submit.php',
                    type:'post',
                    data: data,
                    success:function(response){
                        
                        console.log(response);
                        var result = $.parseJSON(response);
                        if(result[0] == 1){
                        swal("Successfully!", result[1], "success");
                        $('#data-table').DataTable().ajax.reload();
                        $("#myModal").modal('toggle');
                        } else{
                        swal("Error!", result[1], "error");
                        }
                    }
                });
    }
    	$('#realname').selectpicker();
    
    $(window).resize(function () { 
        var width = $(window).width();
        //console.log(width)
       if(width < 767){
          //location.reload(); 
       }
      
    });
    
    </script>
</body>


</html>