<?php 
   
    require_once "../include/load.php";
    $db->title = 'ES | Leads table';
    $role_id = $db->role_id;
    
    $pagecode =  "p_l_d";
    if(!$db->pageCode($pagecode)){
        echo "File Not Found!";
        die();
    }
    
    
    $db->title = 'ES | Leads Hide table';
    //  include "../include/main.function.php";
    //  $role_id = $db->user_id;
     
    //  $query = "select * from * in_user"

?>

<!DOCTYPE html>
<html>

<?php

 include "../include/header.php";

 ?>

<style>
      .selected{
        background-color:#082150 !important;
        color:white !important;
    }
    
    .selected a{
        color:white !important;
    }
    
    .table a {
        color:black ;
    }
</style>

<body class="noselect">
    <?php include('../include/aside.php'); ?>
    <div class="main_content w-100">
        <div class="container-fluid">
           <?php include('../include/top.php'); ?>
            <div class="row">
                <div class="col-xl-6 col-lg-6 col-md-12 col-sm-12 offset-xl-3 offset-lg-3">
                    <div class="dash_head_tabs w-100 mt-3 text-center">
                        <ul class="nav nav-tabs d-flex border-0" id="myTab" role="tablist">
                            <input type="hidden" value='all' id='team' />
                            <?php
                                $active = '';
                            if($db->team_code == 'all'){ ?>
                            <li class="nav-item flex-fill" onclick="tab('all')" role="presentation">
                                <a class="nav-link active" id="allteam-tab" data-toggle="tab" href="#allleads"
                                    role="tab" aria-controls="allleads" aria-selected="true">All Leads</a>
                            </li>
                            <?php
                            }else{
                                $active = 'active';
                            };
                                $teams = $db->getTeam();
                            
                                while($row = mysqli_fetch_array($teams)){
                            ?>
                                
                                <li class="nav-item flex-fill" role="presentation">
                                    <a class="nav-link <?=$active;?>" id="teamb-tab" onclick="tab('<?=$row['code'];?>')" data-toggle="tab" href="#allleads" role="tab" aria-controls="allleads" aria-selected="false"><?php echo $row['name'] ?> Leads</a>
                                </li>
                                
                            <?php  
                                };
                            ?>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="tab-content w-100 mt-3" id="myTabContent">
                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                        <form class="mt-3 p-3 shadow-sm table_filtr">
                            <div class="row">
                                <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12">
                                    <div class="form-group mb-lg-0">
                                        
                                       <select class="form-control shadow-sm p-3" id="website_id" onchange="filter()">
                                              <option value="all" >Select Website</option>
                                              <?php 
                                                    $team =  $db->team_code;
                                                    $fetchWeb = $db->getWebsites($team);
                                                    
                                                    while($row = mysqli_fetch_array($fetchWeb)){
                                                        if($row['status'] == 1){  
                                                            $url = ltrim($row['url'],"www."); 
                                                            $id = $row['id'];
                                                            $name = $url.' - Team '.$row['team'];
                                                            
                                                            echo "<option value='$id'>$name</option>";                                   
                                                        }
                                                    }
                                                ?>
                                              </select>
                                    </div>
                                </div>
                                <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12">
                                    <div class="form-group mb-lg-0">

                                    <select class="form-control shadow-sm p-3" id="status_id" onchange="filter()">
                                            <option value="all">Select Status</option>
                                            <option value="0">Lead Owned</option>
                                            <option value="1">In Conversation</option>
                                            <option value="2">Negotiation</option>
                                            <option value="3">Close Won</option>
                                            <option value="4">Close Lost</option>
                                            <option value="5">Invalid</option>
                                            <option value="6">Duplicate Lead</option>
                                            <option value="7">Lead Free</option>
                                            <option value="8">Not Intrested</option>
                                            <option value="9">Non Compliant</option>
                                            <option value="11">Junk Leads</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12">
                                    <div class="form-group mb-lg-0">
                                        <select class="form-control shadow-sm p-3" id="user_id" onchange="filter()">
                                          <option value="all" >Select User</option>
                                          <?php
                                            $userqu= $db->getUsersS();
                                            while($userfetch = mysqli_fetch_array($userqu)){?>
                                                <option value="<?=$userfetch['id'] ?>"><?=$userfetch['first_name']." - ".$userfetch['last_name']." { ".$userfetch['team'].' }' ?></option>
                                            
                                            <?php };?>
                                          </select>
                                    </div>
                                </div>
                                <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12">
                                    <div class="form-group mb-lg-0">
                                    <input type="date" id="sdate" class="form-control shadow-sm p-3"
                                            onchange="filter()" placeholder="Start Date">
                                    </div>
                                </div>
                                <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12">
                                    <div class="form-group mb-lg-0">
                                    <input type="date" id="edate" class="form-control shadow-sm p-3"
                                            onchange="filter()" placeholder="End Date">
                                    </div>
                                </div>
                            <?php 
                                if($db -> admin || $role_id == 19 || $role_id == 20 ){ ?>
                                   <!--for admin and QA only-->
                                
                                <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12">
                                    <div class="form-group mb-lg-0">
                                        <button type="button" id='delete_button' class="btn btn-info btn-sm p-3 btn-block">Undo
                                            Selected leads</button>
                                    </div>
                                </div>
                                </div>
                            
                            <?php } ?>
                            
                            </div>
                        </form>
                    </div>
                    <div class="tab-pane fade show active" id="allleads" role="tabpanel" aria-labelledby="allleads">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-md-12">
                            <div class="card shadow-sm border-0 mb-4 innr_pge_card mt-3">
                                <div class="card-header border-0 text-white pt-3 pb-3">
                                    <h5 class="text-uppercase font-weight-bold">Leads Table</h5>
                                </div>
                                <div class="card-body table-responsive">
                                    <table id="data-table"
                                        class="table table-bordered table-striped table-hide-first-column"
                                        style="width: 100%;">
                                        <thead>
                                            <tr>
                                               <th>#</th>
                                                <th>Lead Code</th>
                                                <th>Name</th>
                                                <th>Email</th>
                                                 <th>Number</th> 
                                                <!-- <th>IP Address</th> -->
                                                <!-- <th>More Info</th> -->
                                                <th>Created Date</th>
                                                <!-- <th>Expected Date</th> -->
                                                <!-- <th>Expected Amount</th> -->
                                                <th>Last Updated</th>
                                                <th>Owner</th>
                                                <th>Websites</th>
                                                <th>Status</th>
                                                <th>Team</th>
                                                <!-- <th>Review Status</th> -->
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>

    <?php include('../include/footer.php'); ?>

    <script>
  

      $(function(){
        var lead_codes = [];
        $("body").addClass("noselect");
        $("body").on("contextmenu",function(e){
        return false;
            });
             
             tab('<?=$db->team_code?>');
             
             
     $('#data-table tbody').on( 'click', 'tr', function () {
        $(this).toggleClass('selected');
        $(".selected td:nth-child(1)").addClass("selection");
        $(".selected input[type='checkbox']:checked");
      });

   
     $('#delete_button').click(function(){
        lead_codes = [];
        leads = [];
        
        $.each($("table .selected input"), function(){
            lead_codes.push($(this).val());
            leads.push($(this).data("leadcode"));
        });

       
          swal({
                title: "Are you sure?",
                text: " Do you recover this imaginary Lead!"+leads,
                icon: "warning",
                buttons: true,
                dangerMode: true,
            })
            .then((willDelete) => {
                if (willDelete) {
                    
                    $.ajax({
                        url:'action.php',
                        type:'post',
                         data:{'id':lead_codes , action : 'delete_multiple','undo':'1'},
                        success:function(response){
                            console.log(response)
                            if(response == lead_codes.length){
                            $("#newTicketModal").modal('toggle');
                            $('#data-table').DataTable().ajax.reload();
                            swal("Successfully!", "Deleted Selected Lead", "success")
                            } else{ swal("Error!", response, "error") };
                            //alert(response);
                        }
                    });
                } else {
                    swal("Your imaginary Leads is safe!");
                    lead_codes = [];
                    $("tr").removeClass("selected");
                }
            });
        
    });
});


    function tab(val) {
        $('#team').val(val);
        filter();
    }
    
    var width = $(window).width();
    function filter() {
        var sdate = $("#sdate").val();
        var edate = $("#edate").val();
        var mode = 100;
        var users = $('#user_id').val();
        var website = $('#website_id').val();
        var status = $('#status_id').val();
        var value = '';
        var year = '';
        var month = '';
        var lead_team = $('#team').val();

        var table = $('#data-table').DataTable();
        table.destroy();

        $('#data-table').dataTable({
            "select": {
                style: 'multi'
            },
            "responsive" : {
              details: {
                type: 'column',
                target: 0
                }
            },
            "pageLength": 50,
            "serverSide": true,
            "pagenation": true,
            "lengthMenu": [
                [10, 25, 50, 100],
                [10, 25, 50, 100]
            ],
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {},

            columnDefs: [{
                className: 'dtr-control',
                orderable: false,
                targets: 1,
            }, ],

            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {},
            "columnDefs": [],

            "ajax": {
                url: "response.php",
                // url: "response_backup.php",
                type: "post",
                data: {
                    'mode': mode,
                    'website': website,
                    'users': users,
                    'sdate': sdate,
                    'edate': edate,
                    'status': status,
                    'value': value,
                    'years': year,
                    'month': month,
                    'table': lead_team,
                    'isdeletepage': 'hide'
                },
                error: function(e) {
                    $("#employee_grid_processing").css("display", "none");
                    console.log(e)
                }
            }
        });

    }

    function edit(id) {
        data = {
            action: 'edit',
            id: id
        }
        action('Edit Details', data, '', '')
    }

    function view(id) {
        data = {
            action: 'view',
            id: id
        }
        action('More Detail', data, '', '')
    }

    function info(id) {
        data = {
            action: 'customerinfo',
            id: id
        }
        action('Customer Info', data, '', '')
    }

    function history(id){
      data = {action : 'history' , id : id }
      action('History',data , '' , '')
    }
    
    function deleted(id) {

        swal({
                title: "Are you sure?",
                text: "Once deleted, you will not be able to recover this imaginary file!",
                icon: "warning",
                buttons: true,
                dangerMode: true,
            })
            .then((willDelete) => {
                if (willDelete) {
                    data = {
                        action: 'delete',
                        id: id
                    }
                    action('Delete Payments', data, '', '')
                } else {
                    swal("Your imaginary file is safe!");
                }
            });

    }

    function action(header, data, btn, clicks) {
        var data = data;
        $.ajax({
            url: 'action.php',
            type: 'POST',
            data: data,
            success: function(res) {
                if(header == 'edit'){
                    $('#myModal .modal-lg').css('max-width' , '800px')
                }else{
                    $('#myModal .modal-lg').css('max-width' , '1200px')
                }
                modals(header, res, btn, clicks);

            },
            error: function(e) {
                console.log('Ajax Error' + e)
            }
        })
    }
    
    function action_res(header,data){
      var data = data;
      $.ajax({
        url : 'action_response.php',
        type : 'POST',
        data : data,

        success : function(res){
          
          console.log(res);
          modals(header,res,'','');
          $('#data-table').DataTable().ajax.reload();
        },
        error : function(e){
          console.log('Ajax Error'+e)
        }
      })
    }
        
    function action_res_img(header,data){
      var data = data;
      $.ajax({
        url : 'action_response.php',
        type : 'POST',
        data : data,
        contentType: false,
        processData: false,
        success : function(res){
          
          console.log(res);
          modals(header,res,'','');
          $('#data-table').DataTable().ajax.reload();
        },
        error : function(e){
          console.log('Ajax Error'+e)
        }
      })
    }
    
    $(window).resize(function () { 
        var width = $(window).width();
        //console.log(width)
       if(width < 767){
          //location.reload(); 
       }
      
    });
    
    </script>
</body>


</html>