<?php 
   
    include ("../include/load.php");
    $pagecode = "p_u_m";
    
    if(!$db->pagecode($pagecode)){
        echo "File Not Found !";
        die();
    }
    $db->title = 'ES | User table';

?>

<!DOCTYPE html>
<html>

<?php

 include "../include/header.php";

 ?>

<body class="noselect">

    <?php include('../include/aside.php'); ?>

    <div class="main_content w-100">
        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-6">
                    <ul class="dash_head_left mb-3 mt-3 w-100">
                        <li class="nav-item active d-inline-block list-unstyled"> <span
                                class="nav-link border rounded bg-white shadow-sm font-weight-bold">Admin
                                Dashboard</span> </li>
                        <li class="nav-item d-inline-block list-unstyled"> <span class="nav-link">Details of
                                <strong>AUGUST-2020</strong> Only <a class="btn btn-primary btn-sm ml-3"
                                    onClick="test()"><i class="icofont-refresh"></i></a></span>
                        <li class="nav-item list-unstyled d-inline-block"></li>
                        </li>
                        <li class="nav-item active d-inline-block list-unstyled">
                            <div class="spinner-border spinner-border-sm text-primary" style='display : none'
                                id='loader' role="status">
                                <span class="sr-only">Loading...</span>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="row">
                <div class="col-xl-6 col-lg-6 col-md-12 col-sm-12 offset-xl-3 offset-lg-3">
                    <div class="dash_head_tabs w-100 mt-3 text-center">
                        <input type="hidden" value='all' id='team' />
                        <ul class="nav nav-tabs d-flex border-0" id="myTab" role="tablist">
                            <li class="nav-item flex-fill" role="presentation">
                                <a class="nav-link active" id="allteam-tab" onclick="tab('all')" data-toggle="tab"
                                    href="#allleads" role="tab" aria-controls="allleads" aria-selected="true">All Users</a>
                            </li>
                            <?php
                            $teams = $db->qu->query('select * from team');
                            while($row = mysqli_fetch_array($teams)){ ?>

                            <li class="nav-item flex-fill" role="presentation">
                                <a class="nav-link" id="teamb-tab" onclick="tab('<?=$row['code'];?>')" data-toggle="tab"
                                    href="#allleads" role="tab" aria-controls="allleads"
                                    aria-selected="false"><?php echo $row['name'] ?> Users</a>
                            </li>
                    
                            <?php }; ?>
                    
                        </ul>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="tab-content w-100 mt-3" id="myTabContent">
                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                        <form class="mt-3 p-3 shadow-sm table_filtr">
                            <div class="row custom-center">
                                
                                <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12">
                                    <div class="form-group mb-lg-0">
                                        <select class="form-control shadow-sm p-3" id="user_id" onchange="filter()">
                                            <option value="all">Select User</option>
                                           
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12">
                                    <div class="form-group mb-lg-0">
                                        <select class="form-control shadow-sm p-3" id="status_id" onchange="filter()">
                                            <option value="all">Select Status</option>
                                            <option value=1>Active</option>
                                            <option value=0>Inactive</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12">
                                    <div class="form-group mb-lg-0">
                                        <select class="form-control shadow-sm p-3" id="O_status_id" onchange="filter()">
                                            <option value="all">Out side Status</option>
                                            <option value=1>Out side Active</option>
                                            <option value=0>Out side Inactive</option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12">
                                    <div class="form-group mb-lg-0">
                                        <input type="date" id="sdate" class="form-control shadow-sm p-3"
                                            onchange="filter()" placeholder="Start Date">
                                    </div>
                                </div>
                                
                                <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12 ">
                                    <div class="form-group mb-lg-0">
                                        <select  class="selectpicker form-control"  data-live-search="true" id="realname" onchange="filter()">
                                            <option value="all">Select Real Name</option>
                                    <?php $names = $db->qu->query("select fk_parent_id, first_name, last_name from in_user_name WHERE first_name != '' AND first_name != '0'  ");
                                    while($row = mysqli_fetch_array($names)){ ?>
                                    <option value="<?=$row['fk_parent_id']?>"><?=$row['first_name'].' '.$row['last_name']?></option>
                                    <?php }; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="tab-pane fade show active" id="allleads" role="tabpanel" aria-labelledby="allleads">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-md-12">
                            <div class="card shadow-sm border-0 mb-4 innr_pge_card mt-3">
                                <div class="card-header border-0 text-white pt-3 pb-3">
                                    <h5 class="text-uppercase font-weight-bold">Users</h5>
                                </div>
                                <div class="card-body table-responsive">
                                    <table id="data-table" class="table table-bordered table-striped ">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Profile Pic</th>
                                                <th>Employee Id</th>
                                                <th>User Name</th>
                                                <th>Full Name</th>
                                                <th>Role </th>
                                                <th>Created By</th>
                                                <th>CREATED AT</th>
                                                <th>Team</th>
                                                <th>Real Name</th>
                                                <th>Extension</th>
                                                <th>Stauts</th>
                                                <th>Access</th>
                                                <th>Action</th>
                                                <th>Login</th>
                                            </tr>
                                        </thead>
                                        <tbody>

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
  


 <?php include('../include/footer.php'); ?>


    <script>
    $(function() {
        tab('all');
            
    })

    function tab(val) {
        $('#team').val(val);
        filter();
    }


    function filter() {
        var team = $('#team').val(); //hidden filed
        var users = $('#user_id').val();
        var status = $('#status_id').val();
        var o_status = $('#O_status_id').val();
        var realname = $('#realname').val();
        var datatable = $('#data-table').DataTable();

        datatable.destroy();

        $('#data-table').dataTable({
            "select": {
                style: 'multi'
            },
            "responsive": {
                details: {
                    type: 'column',
                    
                }
            },
            "columnDefs": [ {
                className: 'dtr-control',
                orderable: false,
                targets:   0
            } ],
            "pageLength": 10,
            "serverSide": true,
            "pagenation": true,
            "lengthMenu": [
                [10, 25, 50, 100],
                [10, 25, 50, 100]
            ],
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {},
            "columnDefs": [],

            "ajax": {
                url: "response.php",
                type: "post",
                data: {
                    'team': team,
                    'users': users,
                    'status': status,
                    'realname': realname,
                    'o_status' : o_status
                },
                error: function() {
                    $("#employee_grid_processing").css("display", "none");
                }
            }
        });

    }

    function edit(id,roleid) {
        data = {
            action: 'edit',
            c_roleid: roleid,
            id: id
        }
        action('Edit User', data, '', '')
    }

    function view(id) {
        data = {
            action: 'paymentslogs',
            id: id
        }
        action('Detail', data, '', '')
    }

    function info(id) {
        data = {
            action: 'paymentslogs',
            id: id
        }
        action('Detail', data, '', '')
    }

    function deleted(id) {

        swal({
                title: "Are you sure?",
                text: "Once deleted, you will not be able to recover this imaginary file!",
                icon: "warning",
                buttons: true,
                dangerMode: true,
            })
            .then((willDelete) => {
                if (willDelete) {
                    data = {
                        action: 'delete',
                        id: id
                    }
                    action('Delete Payments', data, '', '')
                } else {
                    swal("Your imaginary file is safe!");
                }
            });

    }
    
    function edit_submit(id){
        var data = $("#user-form").serializeArray();
            data.push({ name: "action", value: "edit_submit"});
            data.push({ name: "id", value: id });
         submit(data);
    }
    
    
//FUNCTION DEFINES
    function action(header, data, btn, clicks) {
        var data = data;
        $.ajax({
            url: "action.php",
            type: "POST",
            data: data,
            success: function(res) {
                modals(header, res, btn, clicks);
            },
            error: function(error) {
                console.log(error);
            }
        })
    }
    
function submit(data){
                $.ajax({
                    url: 'form_submit.php',
                    type:'post',
                    data: data,
                    success:function(response){
                        //console.log(response);
                        var result = $.parseJSON(response);
                        if(result[0] == 1){
                        swal("Successfully!", result[1], "success");
                        $('#data-table').DataTable().ajax.reload();
                        $("#myModal").modal('toggle');
                        } else{
                        swal("Error!", result[1], "error");
                        }
                    }
                });
    }
    	$('#realname').selectpicker();
    </script>
</body>

</html>