<?php include "../include/main.function.php" ?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;600;700;800&display=swap">
  <link rel="stylesheet" href="https://allyoucan.cloud/cdn/icofont/1.0.1/icofont.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css">
  <link href="//netdna.bootstrapcdn.com/font-awesome/3.2.1/css/font-awesome.css" rel="stylesheet">
  <link rel="stylesheet" href="../css/bootstrap.css">
  <link rel="stylesheet" href="../style.css">
  <title>E-Student Area</title>
</head>
<body>
    
<?php include('../include/aside.php'); ?>

    <div class="main_content w-100">
      <div class="container-fluid">
        <div class="row">
            <div class="col-xl-6">
                <ul class="dash_head_left mb-3 mt-3 w-100">
                  <li class="nav-item active d-inline-block list-unstyled"> <span class="nav-link border rounded bg-white shadow-sm font-weight-bold">Admin Dashboard</span> </li>
                  <li class="nav-item d-inline-block list-unstyled"> <span class="nav-link">Details of <strong>AUGUST-2020</strong> Only <a class="btn btn-primary btn-sm ml-3" onClick="test()"><i class="icofont-refresh"></i></a></span><li class="nav-item list-unstyled d-inline-block"></li>
                  </li>
                  <li class="nav-item active d-inline-block list-unstyled">
                    <div class="spinner-border spinner-border-sm text-primary" style='display : none' id='loader' role="status">
                      <span class="sr-only">Loading...</span>
                    </div>
                  </li>
                </ul>
            </div>
        </div>
        <div class="row">
          <div class="col-xl-6 col-lg-6 col-md-12 col-sm-12 offset-xl-3 offset-lg-3">
            <div class="dash_head_tabs w-100 mt-3 text-center">
              <input type="hidden" value='all' id='table' /> 
              <ul class="nav nav-tabs d-flex border-0" id="myTab" role="tablist">
                <li class="nav-item flex-fill" role="presentation">
                    <a class="nav-link active" id="allteam-tab" onclick="tab('all')" data-toggle="tab" href="#allleads" role="tab" aria-controls="allleads" aria-selected="true">All Invoices</a>
                </li>
                <?php
                    $teams = $db->qu->query('select * from team');
                    while($row = mysqli_fetch_array($teams)){
                ?>
                
                <li class="nav-item flex-fill" role="presentation">
                  <a class="nav-link" id="teamb-tab" onclick="tab('<?=$row['code'];?>')" data-toggle="tab" href="#allleads" role="tab" aria-controls="allleads" aria-selected="false"><?php echo $row['name'] ?> Invoices</a>
                </li>

                <?php  
                    }
            ?>
              </ul>
            </div>
          </div>
        </div>
          <div class="row">
            <div class="tab-content w-100 mt-3" id="myTabContent">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                  <form class="mt-3 p-3 shadow-sm table_filtr">
                    <div class="row custom-center">
                      <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12 ">
                        <div class="form-group mb-lg-0">
                          <select class="form-control shadow-sm p-3" id="website_id" onchange="filter()">
                          <option value="all" >Select Website</option>
                          <?php
                          $websitequ = $db->qu->query('select * from websites order by team');
                             while($webfetch = mysqli_fetch_array($websitequ)){

                              $weburl = str_replace("www.","",$webfetch['url']); 
                          ?>
                            <option value="<?=$webfetch['id'] ?>"><?=$weburl."  Team-".$webfetch['team'] ?></option>
                            
                            <?php
                             };
                             ?>
                          </select>
                        </div>
                      </div>
                      <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12">
                        <div class="form-group mb-lg-0">
                        <select class="form-control shadow-sm p-3" id="user_id" onchange="filter()">
                          <option value="all" >Select User</option>
                          <?php
                          $userqu= $db->qu->query('select * from in_user_profile order by first_name');
                             while($userfetch = mysqli_fetch_array($userqu)){
                          ?>
                            <option value="<?=$userfetch['fk_parent_id'] ?>"><?=$userfetch['first_name']." - ".$userfetch['last_name'] ?></option>
                            
                            <?php
                             };
                             ?>
                          </select>
                        </div>
                      </div>
                      <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12">
                        <div class="form-group mb-lg-0">
                          <select class="form-control shadow-sm p-3" id="status_id" onchange="filter()">
                          <option value="all" >Select Status</option>
                            <option value="1">Paid</option>
                            <option value="0">Unpaid</option>
                          </select>
                        </div>
                      </div>
                      <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12">
                        <div class="form-group mb-lg-0">
                          <input type="date" id="sdate" class="form-control shadow-sm p-3" onchange="filter()" placeholder="Start Date">
                        </div>
                      </div>
                      <div class="co-xl-2 col-lg-2 col-md-6 col-sm-12">
                        <div class="form-group mb-lg-0">
                          <input type="date" id="edate" class="form-control shadow-sm p-3" onchange="filter()" placeholder="End Date">
                        </div>
                      </div>
                    </div>
                  </form>
                </div> 
              <div class="tab-pane fade show active" id="allleads" role="tabpanel" aria-labelledby="allleads">     
                <div class="col-xl-12 col-lg-12 col-md-12 col-md-12">        
                  <div class="card shadow-sm border-0 mb-4 innr_pge_card mt-3">
                    <div class="card-header border-0 text-white pt-3 pb-3">
                      <h5 class="text-uppercase font-weight-bold">Invoices</h5>
                    </div>
                    <div class="card-body table-responsive">
                      <table id="data-table" class="table table-bordered table-striped ">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Invoice No</th>
                                <th>Lead Code</th>
                                <th>Customer Info</th>
                                <th>Created Date</th>
                                <th>Amount</th>
                                <th>Created By</th>
                                <th>Support By</th>
                                <th>Status</th>
                                <th>Website</th>
                                <th>Team</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                          
                        
                            <!-- <tr>
                                <td>1</td>
                                <td>LD-12312</td>
                                <td>John Doe</td>
                                <td><div class="py-1 px-2 bg-info rounded text-white">johndoe123@gmail.com</div></td>
                                <td><div class="py-1 px-2 bg-warning rounded">1231454</div></td>
                                <td>0</td>
                                <td><button type="button" class="btn btn-sm btn-info" data-toggle="modal" data-target="#leads_info">Info</button></td>
                                <td>04-Sep-2020 12:00:00</td>
                                <td>04-Sep-2020 12:00:00</td>
                                <td>0</td>
                                <td>04-Sep-2020 12:00:00</td>
                                <td>Fred (Team B)</td>
                                <td>abcdsefg.com</td>
                                <td><div class="py-1 px-2 bg-warning rounded">Lead Owned</div></td>
                                <td>Review Pending</td>
                                <td>
                                  <button class="btn btn-sm btn-success" data-toggle="modal" data-target="#leads_action"><span><i class="icofont-ui-edit"></i></span></button>
                                  <button class="btn btn-sm btn-danger"><span><i class="icofont-ui-delete"></i></span></button>
                                </td>
                            </tr>
                            <tr>
                                <td>1</td>
                                <td>LD-12312</td>
                                <td>John Doe</td>
                                <td><div class="py-1 px-2 bg-info rounded text-white">johndoe123@gmail.com</div></td>
                                <td><div class="py-1 px-2 bg-warning rounded">1231454</div></td>
                                <td>0</td>
                                <td><button type="button" class="btn btn-sm btn-info">Info</button></td>
                                <td>04-Sep-2020 12:00:00</td>
                                <td>04-Sep-2020 12:00:00</td>
                                <td>0</td>
                                <td>04-Sep-2020 12:00:00</td>
                                <td>Fred (Team B)</td>
                                <td>abcdsefg.com</td>
                                <td><div class="py-1 px-2 bg-warning rounded">Lead Owned</div></td>
                                <td>Review Pending</td>
                                <td>
                                  <button class="btn btn-sm btn-success"><span><i class="icofont-ui-edit"></i></span></button>
                                  <button class="btn btn-sm btn-danger"><span><i class="icofont-ui-delete"></i></span></button>
                                </td>
                            </tr> -->
                        </tbody>                                   
                      </table>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>



<script src="../js/jquery.js"></script>
<script src="../js/popper.js"></script>
<script src="../js/bootstrap.js"></script>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.2.5/js/dataTables.responsive.min.js"></script>
<script src="../js/custom.js"></script>
<?php include('../modals.php'); ?>
    <script>
    $(function(){
        tab('all');  
        // mobile_menu();
    })

    // function mobile_menu(){
    //   var width = $(window).width();
    //   if(width <= 414){
    //   $(".button-li").click(function(){
    //   $(".sidebar_nav").slideToggle();
     
    // });
    //   }
    //   else{
    //     $(".sidebar_nav").css("display","block");
    //   }
    // }

    function tab(val){
      $('#table').val(val);
      filter();
    }


      function filter(){
        var sdate = $("#sdate").val();
        var edate = $("#edate").val();
        var table = $('#table').val();
        var mode = 100;
        var users = $('#user_id').val();
        var website =$('#website_id').val();
        var status = $('#status_id').val();
        var value = '';
        var inv_team = '';
        var datatable = $('#data-table').DataTable();
        datatable.destroy();
         $('#data-table').dataTable({
            "select": {
                style: 'multi'
            },

            "pageLength": 10,
            "serverSide": true,
            "pagenation" : true,
            "lengthMenu": [[10, 25, 50, 100], [10, 25, 50, 100]],
            "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
            },
            "columnDefs": [
              ],
              
            "ajax":{
                url :"response.php",
                type: "post",
                data:{'table' : table,'mode':mode,'website':website,'users':users,  'sdate' : sdate , 'edate' : edate,'status' : status ,'value' : value ,'inv_team':inv_team },
                error: function(){
                    $("#employee_grid_processing").css("display","none");
                }
            } 
        });
        
    }
    function edit(id){
      data = {action : 'action' , id : id }
      action('Action',data , '' ,'')
    }
        
    function view(id){
      data = {action : 'paymentslogs' , id : id }
      action('Detail',data , '' , '')
    }

    function info(invid , pid ){
      data = {action : 'customerinfo' , id : invid , pid : pid }
      action('Customer Info',data , '' , '')
    }

 


    function deleted(id){
      
      swal({
        title: "Are you sure?",
        text: "Once deleted, you will not be able to recover this imaginary file!",
        icon: "warning",
        buttons: true,
        dangerMode: true,
      })
      .then((willDelete) => {
        if (willDelete) {
          data = {action : 'delete' , id : id }
          action('Delete Payments',data , '' , '')
        } else {
          swal("Your imaginary file is safe!");
        }
      });
      
    }
    function action(header, data , btn, clicks){
      var data = data;
      $.ajax({
        url:"action.php",
        type:"POST",
        data:data,
        success:function(res){
          modals(header,res,btn,clicks);
        },
        error:function(error){
          console.log(error);
        }
      })
    }
    </script>
</body>
</html>