<?php


require 'vendor/autoload.php'; // Load PhpSpreadsheet
use PhpOffice\PhpSpreadsheet\IOFactory;

$host = "localhost";
$user = "inventive_newcrmdb";
$password = "QK{1)&Cs2j4(";
$database = "inventive_newcrmdb"; // Update with your actual DB name

$conn = new mysqli($host, $user, $password, $database);
if ($conn->connect_error) {
    die(json_encode(["status" => "danger", "message" => "Database connection failed: " . $conn->connect_error]));
}

// Check if file is uploaded
if (!isset($_FILES['file']) || $_FILES['file']['error'] !== 0) {
    die(json_encode(["status" => "danger", "message" => "File upload failed"]));
}

// Validate file type
$allowedExtensions = ['xls', 'xlsx'];
$fileExt = pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION);
if (!in_array(strtolower($fileExt), $allowedExtensions)) {
    die(json_encode(["status" => "danger", "message" => "Invalid file type"]));
}

$fileName = $_FILES['file']['tmp_name'];

try {
    // Load Excel File
    $spreadsheet = IOFactory::load($fileName);
    $sheet = $spreadsheet->getActiveSheet();
    $sheetData = $sheet->toArray();

    // Skip the header row (optional)
    array_shift($sheetData);

    // Function to get or insert and return ID
    function getOrInsertID($conn, $table, $idColumn, $nameColumn, $value) {
        $id = null;

        // Check if value exists
        $stmt = $conn->prepare("SELECT $idColumn FROM $table WHERE $nameColumn = ?");
        $stmt->bind_param("s", $value);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($data = $result->fetch_assoc()) {
            $id = $data[$idColumn]; // Existing ID
        } else {
            // Insert new record and get the new ID
            $stmt = $conn->prepare("INSERT INTO $table ($nameColumn) VALUES (?)");
            $stmt->bind_param("s", $value);
            $stmt->execute();
            $id = $stmt->insert_id;
        }
        $stmt->close();
        return $id;
    }

    foreach ($sheetData as $row) {
        $customerName  = trim($row[2]);
        $customerEmail = trim($row[3]);
        $customerPhone = trim($row[4]);
        $brandID       = $_POST["brand"];
        $service       = trim($row[6]);
        $status        = trim($row[7]);
        $source        = trim($row[8]);
        $createDate    = trim($row[1]); // Example: 1-Jan-25
        $agentName     = trim($row[4]); // Using same as customer phone

        // Format Date (Convert "1-Jan-25" to "YYYY-MM-DD")
        $formattedDate = date("Y-m-d", strtotime($createDate));

        // Get or Insert IDs
        $serviceID = getOrInsertID($conn, "ServiceTable", "ServiceID", "ServiceName", $service);
        $statusID  = getOrInsertID($conn, "LeadsStatusTable", "LeadStatusID", "LeadStatusName", $status);
        $sourceID  = getOrInsertID($conn, "SourceTable", "SourceID", "SourceName", $source);

        // Default PlatformID
        $platformID = 1;
        $agentID    = 1;  // Static AgentID
        $comments   = 'No comments';

        // 🚀 INSERT Customer Data
        $stmt = $conn->prepare("INSERT INTO CustomerTable (CustomerName, CustomerEmail, CustomerNumber) VALUES (?, ?, ?)");
        $stmt->bind_param("sss", $customerName, $customerEmail, $customerPhone);
        if (!$stmt->execute()) {
            die(json_encode(["status" => "danger", "message" => "Failed to insert customer: " . $stmt->error]));
        }
        $customerID = $conn->insert_id; // Get last inserted ID
        $stmt->close();

        // Generate LeadCode
        $leadCode = "LD-" . $customerID;

        // 🚀 INSERT Lead Data
        $stmt = $conn->prepare("INSERT INTO LeadsTable (LeadCode, CustomerID, BrandID, CreateDate, Service, StatusID, SourceID, AgentID, Comments, AgentName, PlaformID) 
                                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("siissiiissi", $leadCode, $customerID, $brandID, $formattedDate, $serviceID, $statusID, $sourceID, $agentID, $comments, $agentName, $platformID);

        if (!$stmt->execute()) {
            die(json_encode(["status" => "danger", "message" => "Failed to insert lead: " . $stmt->error]));
        }
        $stmt->close();
    }

    echo json_encode(["status" => "success", "message" => "Data imported successfully"]);
} catch (Exception $e) {
    echo json_encode(["status" => "danger", "message" => "Error processing file: " . $e->getMessage()]);
}

$conn->close();
?>
