<?php
$host = "localhost";
$user = "inventive_newcrmdb";
$password = "QK{1)&Cs2j4(";
$database = "inventive_newcrmdb";

$conn = new mysqli($host, $user, $password, $database);
if ($conn->connect_error) {
    die("Database connection failed: " . $conn->connect_error);
}

// Fetch brands from BrandTable
$brandOptions = "";
$result = $conn->query("SELECT BrandID, BrandName FROM BrandTable");
while ($row = $result->fetch_assoc()) {
    $brandOptions .= "<option value='{$row['BrandID']}'>{$row['BrandName']}</option>";
}
$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bootstrap 5 Excel Upload</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .upload-box {
            border: 2px dashed #007bff;
            padding: 30px;
            text-align: center;
            border-radius: 10px;
            background: #f8f9fa;
            cursor: pointer;
        }
        .upload-box:hover {
            background: #e9ecef;
        }
        .upload-box input {
            display: none;
        }
    </style>
</head>
<body>
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <h4 class="mb-3">Upload Excel File</h4>
                <form id="uploadForm">
                    <div class="mb-3">
                        <label class="form-label">Select Brand:</label>
                        <select class="form-select" name="brand" id="brand" required>
                            <option value="">Choose Brand</option>
                            <?= $brandOptions ?>
                        </select>
                        <div class="invalid-feedback">Please select a brand.</div>
                    </div>
                    <div class="upload-box" id="drop-area">
                        <p class="mb-2">Drag & Drop Excel file here or click to upload</p>
                        <input type="file" id="fileInput" name="file" accept=".xls,.xlsx" required>
                        <button type="button" class="btn btn-primary mt-2">Browse Files</button>
                    </div>
                    <div class="progress mt-3" style="height: 20px;">
                        <div id="progress-bar" class="progress-bar" role="progressbar" style="width: 0%;" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">0%</div>
                    </div>
                    <div id="upload-status" class="mt-3"></div>
                    <button type="submit" class="btn btn-success mt-3">Upload</button>
                </form>
            </div>
        </div>
    </div>

    <script>
        const dropArea = document.getElementById("drop-area");
        const fileInput = document.getElementById("fileInput");
        const uploadForm = document.getElementById("uploadForm");
        const brandSelect = document.getElementById("brand");
        const uploadStatus = document.getElementById("upload-status");
        const progressBar = document.getElementById("progress-bar");

        dropArea.addEventListener("click", () => fileInput.click());
        dropArea.addEventListener("dragover", (e) => {
            e.preventDefault();
            dropArea.classList.add("border-primary");
        });
        dropArea.addEventListener("dragleave", () => {
            dropArea.classList.remove("border-primary");
        });
        dropArea.addEventListener("drop", (e) => {
            e.preventDefault();
            dropArea.classList.remove("border-primary");
            fileInput.files = e.dataTransfer.files;
        });

        uploadForm.addEventListener("submit", function(e) {
            e.preventDefault();

            if (brandSelect.value === "") {
                brandSelect.classList.add("is-invalid");
                return;
            } else {
                brandSelect.classList.remove("is-invalid");
            }

            let formData = new FormData(this);
            let xhr = new XMLHttpRequest();
            xhr.open("POST", "upload.php", true);

            // Track upload progress
            xhr.upload.onprogress = function(e) {
                if (e.lengthComputable) {
                    let percent = Math.round((e.loaded / e.total) * 100);
                    progressBar.style.width = percent + "%";
                    progressBar.innerHTML = percent + "%";
                    progressBar.setAttribute("aria-valuenow", percent);
                }
            };

            xhr.onload = function() {
                if (xhr.status === 200) {
                    let data = JSON.parse(xhr.responseText);

                    // Show message
                    uploadStatus.innerHTML = `<div class='alert alert-${data.status}'>${data.message}</div>`;

                    // Reset progress bar on success
                    if (data.status === "success") {
                        progressBar.style.width = "100%";
                        progressBar.innerHTML = "Upload Complete";
                        progressBar.classList.add("bg-success");

                        // Reset form after success
                        setTimeout(() => {
                            uploadStatus.innerHTML = "";
                            progressBar.style.width = "0%";
                            progressBar.innerHTML = "0%";
                            progressBar.classList.remove("bg-success");
                            uploadForm.reset();
                        }, 3000);
                    } else {
                        progressBar.classList.add("bg-danger");
                    }
                } else {
                    uploadStatus.innerHTML = `<div class='alert alert-danger'>Upload failed</div>`;
                    progressBar.classList.add("bg-danger");
                }
            };

            xhr.onerror = function() {
                uploadStatus.innerHTML = `<div class='alert alert-danger'>An error occurred during upload</div>`;
            };

            xhr.send(formData);
        });
    </script>
</body>
</html>
