<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bootstrap 5 Excel Upload</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .upload-box {
            border: 2px dashed #007bff;
            padding: 30px;
            text-align: center;
            border-radius: 10px;
            background: #f8f9fa;
            cursor: pointer;
        }
        .upload-box:hover {
            background: #e9ecef;
        }
        .upload-box input {
            display: none;
        }
    </style>
</head>
<body>
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="upload-box" id="drop-area">
                    <p class="mb-2">Drag & Drop Excel file here or click to upload</p>
                    <input type="file" id="fileInput" accept=".xls,.xlsx">
                    <button class="btn btn-primary mt-2">Browse Files</button>
                    <div id="upload-status" class="mt-3"></div>
                </div>
            </div>
        </div>
    </div>
    
    <script>
        const dropArea = document.getElementById("drop-area");
        const fileInput = document.getElementById("fileInput");
        const uploadStatus = document.getElementById("upload-status");
        
        dropArea.addEventListener("click", () => fileInput.click());
        dropArea.addEventListener("dragover", (e) => {
            e.preventDefault();
            dropArea.classList.add("border-primary");
        });
        dropArea.addEventListener("dragleave", () => {
            dropArea.classList.remove("border-primary");
        });
        dropArea.addEventListener("drop", (e) => {
            e.preventDefault();
            dropArea.classList.remove("border-primary");
            handleFiles(e.dataTransfer.files);
        });
        
        fileInput.addEventListener("change", () => {
            handleFiles(fileInput.files);
        });
        
        function handleFiles(files) {
            if (files.length > 0) {
                let formData = new FormData();
                formData.append("file", files[0]);
                
                fetch("upload.php", {
                    method: "POST",
                    body: formData
                })
                .then(response => response.json())
                .then(data => {
                    uploadStatus.innerHTML = `<div class='alert alert-${data.status}'>${data.message}</div>`;
                })
                .catch(error => {
                    uploadStatus.innerHTML = `<div class='alert alert-danger'>Upload failed</div>`;
                });
            }
        }
    </script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
