<?php
    require_once "../include/load.php";
    $db->title = 'ES | Outsiders Log';
    $pagecode = '';
    include "../include/header.php";
?>
<body>
    <?php include('../include/aside.php'); ?>

    <div class="main_content w-100">
        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-6">
                    <ul class="dash_head_left mb-3 mt-3 w-100">
                        <li class="nav-item active d-inline-block list-unstyled"> <span class="nav-link border rounded bg-white shadow-sm font-weight-bold">Admin Dashboard</span> </li>
                        <li class="nav-item active d-inline-block list-unstyled">
                            <div class="spinner-border spinner-border-sm text-primary" style='display : none' id='loader' role="status">
                                <span class="sr-only">Loading...</span>
                            </div>
                        </li>
                    </ul>   
                </div>
            </div>



                
                    <div class="tab-pane fade show active" id="allleads" role="tabpanel" aria-labelledby="allleads">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-md-12">
                            <div class="card shadow-sm border-0 mb-4 innr_pge_card mt-3">
                                <div class="card-header border-0 text-white pt-3 pb-3">
                                    <h5 class="text-uppercase font-weight-bold">Outsiders Log</h5>
                                </div>
                                <div class="card-body table-responsive">
                                    <table id="data-table" class="table table-bordered table-striped table-hide-first-column" style="width: 100%;">
                                        <thead>
                                            <tr>
                                            <th>S.No</th>
                                            <th>User ID</th>
                                            <th>User Name</th>
                                            <th>User IP</th>
                                            <th>URL</th>
                                            <th>Access Date</th>
                                            </tr>
                                        </thead>
                                        <tbody>

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>

    <?php include('../include/footer.php'); ?>


    <script>
        $(function() {
            filter('all');
        })

        function filter(id) {
            var tcname = $("#tcname").val();
            var table = $('#data-table').DataTable();
            table.destroy();
            $('#data-table').dataTable({
                "select": {
                    style: 'multi'
                },
                'processing': true,
                'serverSide': true,
                'serverMethod': 'post',
                "pageLength":10,
                //"pagingType": "simple",
                "lengthMenu": [ 10, 25, 50, 75],
                "bPaginate":true,
                "searching":true,
                "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {},
                "columnDefs": [
                ],
                "ajax": {
                    url: "response.php",
                    type: "post",
                    data: {'team':id, 'tcname': tcname},
                    error: function(e) {
                        $("#employee_grid_processing").css("display", "none");
                        console.log(e)
                    }
                }
            });

        }




    </script>
</body>

</html>