<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;600;700;800&display=swap">
	<link rel="stylesheet" href="https://allyoucan.cloud/cdn/icofont/1.0.1/icofont.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css">
  <link rel="stylesheet" href="css/bootstrap.css">
	<link rel="stylesheet" href="style.css">
  <style>
    .stps_prgrss {display: grid; grid-template-columns: repeat(auto-fit, minmax(0, 1fr)); }
.stps_prgrss-btn {transition-property: all; transition-duration: 0.15s; transition-timing-function: linear; transition-delay: 0s; position: relative; padding-top: 20px; color: rgba(108, 117, 125, 0.7); text-indent: -9999px; border: none; background-color: transparent; outline: none !important; cursor: pointer; }
@media (min-width: 500px) {.stps_prgrss-btn {text-indent: 0; } }
.stps_prgrss-btn:before {position: absolute; top: 0; left: 50%; display: block; width: 13px; height: 13px; content: ''; -webkit-transform: translateX(-50%); transform: translateX(-50%); transition: all 0.15s linear 0s, -webkit-transform 0.15s cubic-bezier(0.05, 1.09, 0.16, 1.4) 0s; transition: all 0.15s linear 0s, transform 0.15s cubic-bezier(0.05, 1.09, 0.16, 1.4) 0s; transition: all 0.15s linear 0s, transform 0.15s cubic-bezier(0.05, 1.09, 0.16, 1.4) 0s, -webkit-transform 0.15s cubic-bezier(0.05, 1.09, 0.16, 1.4) 0s; border: 2px solid currentColor; border-radius: 50%; background-color: #fff; box-sizing: border-box; z-index: 3; }
.stps_prgrss-btn:after {position: absolute; top: 5px; left: calc(-50% - 13px / 2); transition-property: all; transition-duration: 0.15s; transition-timing-function: linear; transition-delay: 0s; display: block; width: 100%; height: 2px; content: ''; background-color: currentColor; z-index: 1; }
.stps_prgrss-btn:first-child:after {display: none; }
.stps_prgrss-btn.js-active {color: #007bff; } 
.stps_prgrss-btn.js-active:before {-webkit-transform: translateX(-50%) scale(1.2); transform: translateX(-50%) scale(1.2); background-color: currentColor; }
.stps_progress {position: relative; }
.stps__panel {position: absolute; top: 0; left: 0; width: 100%; height: 0; opacity: 0; visibility: hidden; }
.stps__panel.js-active {height: auto; opacity: 1; visibility: visible; }
.stps__panel[data-animation="slideHorz"] {left: 50px; }
.stps__panel[data-animation="slideHorz"].js-active {transition-property: all; transition-duration: 0.25s; transition-timing-function: cubic-bezier(0.2, 1.13, 0.38, 1.43); transition-delay: 0s; left: 0; }

  </style>
	<title>E-Student Area</title>
</head>
<body>
<?php include('header.php'); ?>
<div class="main_content w-100">
  <div class="container-fluid">
    <div class="row">
        <div class="col-xl-12 col-lg-12 col-md-12 col-md-12">
          <div class="card shadow-sm border-0 mb-4 innr_pge_card mt-3">
            <div class="card-header border-0 text-white pt-3 pb-3">
              <h5 class="text-uppercase font-weight-bold">Add New Lead</h5>
            </div>
            <div class="card-body">
                <div class="col-12 col-lg-12 mb-4 mt-4">
                  <div class="stps_prgrss">
                    <button class="stps_prgrss-btn js-active" type="button">Step 1</button>
                    <button class="stps_prgrss-btn" type="button">Step 2</button>
                    <button class="stps_prgrss-btn" type="button">Step 3</button>
                    <button class="stps_prgrss-btn" type="button">Step 4</button>
                    <button class="stps_prgrss-btn" type="button">Finish</button>
                  </div>
                </div>
                <div class="col-12 col-lg-12 m-auto">
                  <form class="stps__form">
                    <div class="stps__panel js-active" data-animation="slideHorz">
                      <div class="stps__content">
                        <div class="card shadow-sm border-0 mb-4 innr_pge_card mt-3">
                          <div class="card-header border-0 text-white pt-3 pb-3">
                            <h5 class="text-uppercase font-weight-bold">Step 1</h5>
                          </div>
                          <div class="card-body">
                            <div class="row">
                               <!-- form goes here -->
                            </div>
                          </div>
                        </div>
                        <div class="button-row text-center mt-4">
                          <button class="btn ml-auto js-btn-next modal_btn py-2 px-5 shadow-sm" type="button">Next</button>
                        </div>
                      </div>
                    </div>
       
                    <div class="stps__panel" data-animation="slideHorz">
                      <div class="stps__content">
                        <div class="card shadow-sm border-0 mb-4 innr_pge_card mt-3">
                          <div class="card-header border-0 text-white pt-3 pb-3">
                            <h5 class="text-uppercase font-weight-bold">Step 2</h5>
                          </div>
                          <div class="card-body">
                            <div class="row">
                               <!-- form goes here -->
                            </div>
                          </div>
                        </div>
                        <div class="button-row text-center mt-4">
                          <button class="btn js-btn-prev modal_btn_dark py-2 px-5 shadow-sm" type="button">Prev</button>
                          <button class="btn ml-auto js-btn-next modal_btn py-2 px-5 shadow-sm" type="button">Next</button>
                        </div>
                      </div>
                    </div>
       
                    <div class="stps__panel" data-animation="slideHorz">
                      <div class="stps__content">
                        <div class="card shadow-sm border-0 innr_pge_card mt-3">
                          <div class="card-header border-0 text-white pt-3 pb-3">
                            <h5 class="text-uppercase font-weight-bold">Step 3</h5>
                          </div>
                          <div class="card-body">
                            <div class="row">
                               <!-- form goes here -->
                            </div>
                          </div>
                        </div>
                        <div class="row">
                          <div class="button-row text-center mt-4 col-12">
                            <button class="btn modal_btn_dark py-2 px-5 js-btn-prev shadow-sm" type="button">Prev</button>
                            <button class="btn ml-auto js-btn-next modal_btn py-2 px-5 shadow-sm" type="button">Next</button>
                          </div>
                        </div>
                      </div>
                    </div>
       
                    <div class="stps__panel" data-animation="slideHorz">
                      <div class="stps__content">
                        <div class="card shadow-sm border-0 mb-4 innr_pge_card mt-3">
                          <div class="card-header border-0 text-white pt-3 pb-3">
                            <h5 class="text-uppercase font-weight-bold">Step 4</h5>
                          </div>
                          <div class="card-body">
                            <div class="row">
                              <!-- form goes here -->
                            </div>
                          </div>
                        </div>
                        <div class="button-row text-center mt-4">
                          <button class="btn modal_btn_dark py-2 px-5 js-btn-prev shadow-sm" type="button">Prev</button>
                          <button class="btn modal_btn js-btn-next ml-auto py-2 px-5 shadow-sm" type="button">Next</button>
                        </div>
                      </div>
                    </div>
                    <div class="stps__panel" data-animation="slideHorz">
                      <div class="stps__content">
                        <div class="card shadow-sm border-0 mb-4 innr_pge_card mt-3">
                          <div class="card-header border-0 text-white pt-3 pb-3">
                            <h5 class="text-uppercase font-weight-bold">Step 5</h5>
                          </div>
                          <div class="card-body">
                             <!-- form goes here -->
                          </div>
                        </div>
                        <div class="button-row text-center mt-4">
                          <button class="btn modal_btn_dark py-2 px-5 js-btn-prev shadow-sm" type="button">Prev</button>
                          <button class="btn btn-success ml-auto py-2 px-5 shadow-sm" type="button" title="Send">Send</button>
                        </div>
                      </div>
                    </div>
                  </form>
                </div>
          </div>
        </div>
    </div>
  </div>
</div>

<?php include('modals.php'); ?>

<script src="js/jquery.js"></script>
<script src="js/popper.js"></script>
<script src="js/bootstrap.js"></script>

<script src="http://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.2.5/js/dataTables.responsive.min.js"></script>
<!-- <script src="https://www.gstatic.com/charts/loader.js"></script> -->
<script src="js/custom.js"></script>
<script>
  // Form Stepper
const DOMstrings = {
  stepsBtnClass: 'stps_prgrss-btn',
  stepsBtns: document.querySelectorAll(`.stps_prgrss-btn`),
  stepsBar: document.querySelector('.stps_prgrss'),
  stepsForm: document.querySelector('.stps__form'),
  stepsFormTextareas: document.querySelectorAll('.stps__textarea'),
  stepFormPanelClass: 'stps__panel',
  stepFormPanels: document.querySelectorAll('.stps__panel'),
  stepPrevBtnClass: 'js-btn-prev',
  stepNextBtnClass: 'js-btn-next'
};
const removeClasses = (elemSet, className) => {
  elemSet.forEach(elem => {
    elem.classList.remove(className);
  });
};
const findParent = (elem, parentClass) => {
  let currentNode = elem;
  while (!currentNode.classList.contains(parentClass)) {
    currentNode = currentNode.parentNode;
  }
  return currentNode;
};
const getActiveStep = elem => {
  return Array.from(DOMstrings.stepsBtns).indexOf(elem);
};
const setActiveStep = activeStepNum => {
  removeClasses(DOMstrings.stepsBtns, 'js-active');
  DOMstrings.stepsBtns.forEach((elem, index) => {
    if (index <= activeStepNum) {
      elem.classList.add('js-active');
    }
  });
};
const getActivePanel = () => {
  let activePanel;
  DOMstrings.stepFormPanels.forEach(elem => {
    if (elem.classList.contains('js-active')) {
      activePanel = elem;
    }
  });
  return activePanel;
};
const setActivePanel = activePanelNum => {
  removeClasses(DOMstrings.stepFormPanels, 'js-active');
  DOMstrings.stepFormPanels.forEach((elem, index) => {
    if (index === activePanelNum) {
      elem.classList.add('js-active');
      setFormHeight(elem);
    }
  });
};
const formHeight = activePanel => {
  const activePanelHeight = activePanel.offsetHeight;
  DOMstrings.stepsForm.style.height = `${activePanelHeight}px`;
};
const setFormHeight = () => {
  const activePanel = getActivePanel();
  formHeight(activePanel);
};
DOMstrings.stepsBar.addEventListener('click', e => {
  const eventTarget = e.target;
  if (!eventTarget.classList.contains(`${DOMstrings.stepsBtnClass}`)) {
    return;
  }
  const activeStep = getActiveStep(eventTarget);
  setActiveStep(activeStep);
  setActivePanel(activeStep);
});
DOMstrings.stepsForm.addEventListener('click', e => {
  const eventTarget = e.target;
  if (!(eventTarget.classList.contains(`${DOMstrings.stepPrevBtnClass}`) || eventTarget.classList.contains(`${DOMstrings.stepNextBtnClass}`)))
  {
    return;
  }
  const activePanel = findParent(eventTarget, `${DOMstrings.stepFormPanelClass}`);
  let activePanelNum = Array.from(DOMstrings.stepFormPanels).indexOf(activePanel);
  if (eventTarget.classList.contains(`${DOMstrings.stepPrevBtnClass}`)) {
    activePanelNum--;
  } else {
    activePanelNum++;
  }
  setActiveStep(activePanelNum);
  setActivePanel(activePanelNum);
});
window.addEventListener('load', setFormHeight, false);
window.addEventListener('resize', setFormHeight, false);
const setAnimationType = newType => {
  DOMstrings.stepFormPanels.forEach(elem => {
    elem.dataset.animation = newType;
  });
};
</script>
</body>
</html>