<div class="page-body">
  <div class="container-fluid">
    <div class="row">
      <div class="col-xl-6 offset-xl-3">
        <div class="card">
          <div class="card-header">
            <h4>Add Email Credentials</h4>
          </div>
          <div class="card-body">
            <form action="<?= base_url('brands/mailsave') ?>" method="POST" class="needs-validation" novalidate>
              
              <div class="mb-3">
                <label for="MailUser" class="form-label">Mail User</label>
                <input type="email" name="MailUser" id="MailUser" class="form-control" required>
                <div class="invalid-feedback">Please enter a valid email.</div>
              </div>

              <div class="mb-3">
                <label for="MailPass" class="form-label">Mail Password</label>
                <input type="password" name="MailPass" id="MailPass" class="form-control" required>
                <div class="invalid-feedback">Please enter the password.</div>
              </div>

              <div class="mb-3">
                <label for="MailServer" class="form-label">Mail Server</label>
                <input type="text" name="MailServer" id="MailServer" class="form-control" required>
                <div class="invalid-feedback">Please enter the mail server.</div>
              </div>

              <div class="mb-3">
                <label for="MailStatus" class="form-label">Mail Status</label>
                <select name="MailStatus" id="MailStatus" class="form-select" required>
                  <option value="" disabled selected>Select status</option>
                  <option value="Active">Active</option>
                  <option value="Inactive">Inactive</option>
                </select>
                <div class="invalid-feedback">Please select the status.</div>
              </div>

              <div class="mb-3">
                <label for="MailCreatedAt" class="form-label">Created At</label>
                <input type="datetime-local" name="MailCreatedAt" id="MailCreatedAt" class="form-control" required>
                <div class="invalid-feedback">Please provide the created date.</div>
              </div>

              <div class="mb-3">
                <label for="MailCreatedBy" class="form-label">Created By</label>
                <input type="text" name="MailCreatedBy" id="MailCreatedBy" class="form-control" required>
                <div class="invalid-feedback">Please provide creator's name.</div>
              </div>

              <div class="text-center">
                <button type="submit" class="btn btn-primary">Save Email</button>
              </div>
              
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<script>
  // Bootstrap validation script
  (function () {
    'use strict'
    const forms = document.querySelectorAll('.needs-validation')
    Array.from(forms).forEach(form => {
      form.addEventListener('submit', event => {
        if (!form.checkValidity()) {
          event.preventDefault()
          event.stopPropagation()
        }
        form.classList.add('was-validated')
      }, false)
    })
  })()
</script>
