<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Menu_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    // Fetch menu items based on role_id
    public function get_menu_items($role_id) {
        $this->db->select('m.id, m.module_name, m.parent_id, m.module_url, m.icon_class, m.icon_class2, mg.title AS menu_title, mg.sort_order');
        $this->db->from('modules m');
        $this->db->join('role_module rm', 'rm.module_id = m.id');
        $this->db->join('menu_group mg', 'mg.id = m.menu_group_id');
        $this->db->where('rm.role_id', $role_id);
        $this->db->order_by('mg.sort_order, m.id', 'ASC');
        $query = $this->db->get();
        return $query->result_array();
    }
}