<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Lead_model extends CI_Model {

    public function __construct() {
        parent::__construct();
        $this->load->database(); // Load the database library
    }

    /**
     * Fetch leads data with customer and brand details using INNER JOIN with pagination.
     *
     * @param int $limit The number of records per page
     * @param int $offset The number of records to skip (for pagination)
     * @return array
     */
    public function get_leads_with_customers_and_brands($limit, $offset) {
        // Use Query Builder to construct the query
        $this->db->select('
            l.LeadID, 
            l.LeadCode, 
            l.CustomerID, 
            l.CreateDate, 
            l.AgentID, 
            l.Comments, 
            l.DisplayID, 
            l.AgentName, 
            l.PlaformID,
            c.CustomerName,
            c.CustomerEmail,
            c.CustomerNumber,
            b.BrandName,
            s.ServiceName, 
            ls.LeadStatusName, 
            ls.LeadStatusColor,
            src.SourceName' // Source Name
        );
        $this->db->from('leadstable l'); // Main table
        $this->db->join('customertable c', 'l.CustomerID = c.CustomerID', 'inner'); // INNER JOIN for customer data
        $this->db->join('brandtable b', 'l.BrandID = b.BrandID', 'inner'); // INNER JOIN for brand data
        $this->db->join('servicetable s', 'l.Service = s.ServiceID', 'inner'); // INNER JOIN for service data
        $this->db->join('leadsstatustable ls', 'l.StatusID = ls.LeadStatusID', 'inner'); // INNER JOIN for status data
        $this->db->join('sourcetable src', 'l.SourceID = src.SourceID', 'inner'); // INNER JOIN for source data
        
        // Apply pagination (limit and offset)
        $this->db->limit($limit, $offset); 

        $this->db->order_by('l.LeadID', 'DESC'); // ORDER BY LeadID DESC
        
        $query = $this->db->get(); // Execute the query

        // Return the result as an associative array
        return $query->result_array();
    }

    /**
     * Get the total number of leads for pagination.
     *
     * @return int
     */
    public function get_total_leads_count() {
        // Count total records in the leadstable
        $this->db->from('leadstable l');
        $this->db->join('customertable c', 'l.CustomerID = c.CustomerID', 'inner');
        $this->db->join('brandtable b', 'l.BrandID = b.BrandID', 'inner');
        $this->db->join('servicetable s', 'l.Service = s.ServiceID', 'inner');
        $this->db->join('leadsstatustable ls', 'l.StatusID = ls.LeadStatusID', 'inner');
        $this->db->join('sourcetable src', 'l.SourceID = src.SourceID', 'inner');
        return $this->db->count_all_results();  // Get the total number of records
    }
}
?>
