<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Brand_model extends CI_Model {

    public function __construct() {
        parent::__construct();
        $this->load->database(); // Load the database library
    }

    /**
     * Fetch leads data with customer and brand details using INNER JOIN with pagination.
     *
     * @param int $limit The number of records per page
     * @param int $offset The number of records to skip (for pagination)
     * @return array
     */
    public function get_brands($limit, $offset) {
        // Use Query Builder to construct the query
        $this->db->select('*');
        $this->db->from('brandtable'); // Main table
        
        // Apply pagination (limit and offset)
        $this->db->limit($limit, $offset); 

        $this->db->order_by('BrandID', 'DESC'); // ORDER BY LeadID DESC
        
        $query = $this->db->get(); // Execute the query

        // Return the result as an associative array
        return $query->result_array();
    }

    /**
     * Get the total number of leads for pagination.
     *
     * @return int
     */
public function get_emails($limit, $offset) {
    $this->db->select('*');
    $this->db->from('BrandEMails');

    $this->db->limit($limit, $offset); 
    $this->db->order_by('MailID', 'DESC');

    $query = $this->db->get();
    return $query->result_array();
}

    public function get_total_emails_count(){
        // Count total records in the leadstable
        $this->db->from('BrandEMails');
        return $this->db->count_all_results();  // Get the total number of records
    }
    public function get_total_brands_count() {
        // Count total records in the leadstable
        $this->db->from('brandtable');
        return $this->db->count_all_results();  // Get the total number of records
    }
}
?>
