<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Template {

    protected $CI;
    protected $layout = 'default'; // Default layout
    protected $title = 'Dashboard'; // Default title
    protected $data = array(); // Data to pass to views

    public function __construct() {
        $this->CI =& get_instance();
        $this->CI->load->model('Menu_model'); // Load the menu model
    }

    // Set the layout
    public function set_layout($layout) {
        $this->layout = $layout;
        return $this;
    }

    // Set the title
    public function set_title($title) {
        $this->title = $title;
        return $this;
    }

    // Add data to pass to views
    public function set_data($data) {
        $this->data = array_merge($this->data, $data);
        return $this;
    }

    // Generate the dynamic menu
    public function generate_menu($role_id) {
        $menu_items = $this->CI->Menu_model->get_menu_items($role_id);
        $menu_tree = $this->build_menu_tree($menu_items);
        return $this->render_menu($menu_tree);
    }

    // Build the menu tree (parent-child structure)
    private function build_menu_tree(array $elements, $parent_id = 0) {
        $branch = array();

        foreach ($elements as $element) {
            if ($element['parent_id'] == $parent_id) {
                $children = $this->build_menu_tree($elements, $element['id']);
                if ($children) {
                    $element['children'] = $children;
                }
                $branch[] = $element;
            }
        }

        return $branch;
    }

    // Render the menu HTML
    private function render_menu($menu, $is_child = false) {
        $html = '';

        // Only add the "Back" button and "Pinned" section for the main menu
        if (!$is_child) {
            $html .= '<ul class="sidebar-links" id="simple-bar">';
            $html .= '<li class="back-btn"><a href="index.html"><img class="img-fluid" src="' . base_url('assets/images/logo/logo-icon.png') . '" alt=""></a>
                      <div class="mobile-back text-end"><span>Back</span><i class="fa fa-angle-right ps-2" aria-hidden="true"></i></div>
                      </li>
                      <li class="pin-title sidebar-main-title">
                        <div> 
                          <h6>Pinned</h6>
                        </div>
                      </li>';
        } else {
            $html .= '<ul class="sidebar-submenu">';
        }

        // Group menu items by menu_title
        $grouped_menu = [];
        foreach ($menu as $item) {
            $grouped_menu[$item['menu_title']][] = $item;
        }

        // Sort the groups by sort_order (if available)
        uasort($grouped_menu, function($a, $b) {
            return $a[0]['sort_order'] <=> $b[0]['sort_order'];
        });

        // Render the menu
        foreach ($grouped_menu as $menu_title => $items) {
            // Add the title for the group (only for the main menu)
            if (!$is_child) {
                $html .= '<li class="sidebar-main-title">';
                $html .= '<div>';
                $html .= '<h6 class="lan-1" data-lang-key="0">' . $menu_title . '</h6>';
                $html .= '</div>';
                $html .= '</li>';
            }

            // Render the menu items
            foreach ($items as $item) {
                $html .= $this->render_menu_item($item);
            }
        }

        $html .= '</ul>';
        return $html;
    }

    private function render_menu_item($item) {
        // Get the current URL (e.g., "leads/show")
        $current_url = $this->CI->uri->uri_string();

        // Check if the current URL starts with the menu item's URL (for parent items)
        $is_active = (strpos($current_url, $item['module_url']) === 0) ? '' : '';

        // If the item has children, check if any child is active
        if (!empty($item['children'])) {
            foreach ($item['children'] as $child) {
                if ($current_url == $child['module_url']) {
                    $is_active = ''; // Mark the parent as active
                    break;
                }
            }
        }

        // Start building the menu item HTML
        $html = '<li class="sidebar-list ' . $is_active . '">';
        $html .= '<i class="fa fa-thumb-tack"></i>';

        // Check if the item has children
        if (empty($item['children'])) {
            // No children: Add the "link-nav" class
            $html .= '<a class="sidebar-link sidebar-title link-nav ' . $is_active . '" href="' . base_url($item['module_url']) . '">';
        } else {
            // Has children: Do not add the "link-nav" class
            $html .= '<a class="sidebar-link sidebar-title ' . $is_active . '" href="javascript:void(0)">';
        }

        // Add SVG icons
        $html .= '<svg class="stroke-icon"><use href="' . base_url($item['icon_class2']) . '"></use></svg>';
        $html .= '<svg class="fill-icon"><use href="' . base_url($item['icon_class2']) . '"></use></svg>';

        // Add the menu item name
        $html .= '<span>' . $item['module_name'] . '</span>';
        $html .= '</a>';

        // Render children if they exist
        if (!empty($item['children'])) {
            $html .= '<ul class="sidebar-submenu">';
            foreach ($item['children'] as $child) {
                // Check if the child URL matches the current URL
                $child_is_active = ($current_url == $child['module_url']) ? '' : '';
                $html .= '<li class="' . $child_is_active . '"><a href="' . base_url($child['module_url']) . '">' . $child['module_name'] . '</a></li>';
            }
            $html .= '</ul>';
        }

        $html .= '</li>';
        return $html;
    }
    // Render the view with the layout
    public function render($view, $data = array()) {
        // Merge additional data
        $data = array_merge($this->data, $data);

        // Add the title to the data array
        $data['title'] = $this->title;

        // Generate the dynamic menu
        $role_id = $this->CI->session->userdata('role_id'); // Get role_id from session
        $data['menu'] = $this->generate_menu(1);

        // Load the header
        $this->CI->load->view('include/header', $data);

        // Load the head menu
        $this->CI->load->view('component/head_menu', $data);

        // Load the aside menu
        $this->CI->load->view('component/aside_menu', $data);

        // Load the main content view
        $this->CI->load->view($view, $data);

        // Load the footer
        $this->CI->load->view('include/footer');
    }
}