<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Leads extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('template'); // Load the Template library
        $this->load->model('Lead_model'); // Load the Lead_model
    }

    public function index() {
        // Set the page title
        $this->template->set_title('Dashboard');

        // Pass additional data to the view
        $data = array(
            'user_name' => $this->session->userdata('user_name')
        );
        
        // Render the dashboard view with the layout
        $this->template->render('dashboard', $data);
    }
    public function show(){
        // Set the page title
        $this->template->set_title('Dashboard');

        // Pass additional data to the view
        $data = array(
            'user_name' => $this->session->userdata('user_name')
        );
        
        // Render the dashboard view with the layout
        $this->template->render('leads/index', $data);
    }
    public function api(){
        // Get the pagination parameters from the request (default values if not provided)
        $limit = $this->input->get('length'); // Number of records per page
        $offset = $this->input->get('start'); // Offset to fetch the data (skip this many records)
    
        // Fetch the paginated data from the model
        $leads = $this->Lead_model->get_leads_with_customers_and_brands($limit, $offset);
    
        // Get the total number of records (for pagination)
        $total_records = $this->Lead_model->get_total_leads_count();
    
        // Prepare the response data
        $response = array(
            'draw' => intval($this->input->get('draw')),  // DataTable draw counter
            'recordsTotal' => $total_records,  // Total records in the database
            'recordsFiltered' => $total_records,  // Records after filtering (for now we don't apply any filtering)
            'data' => $leads  // The paginated data
        );
    
        // Set the content type to JSON and output the data
        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
    }
}