<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Brands extends CI_Controller {
    public function __construct() {
        parent::__construct();
        $this->load->library('template'); // Load the Template library
        $this->load->model('Lead_model'); // Load the Lead_model
        $this->load->model('Brand_model'); // Load the Lead_model
    }
    public function index(){
        // Set the page title
        $this->template->set_title('Dashboard');

        // Pass additional data to the view
        $data = array(
            'user_name' => $this->session->userdata('user_name')
        );
        
        // Render the dashboard view with the layout
        $this->template->render('brands/index', $data);
    }
    public function emails(){
        // Set the page title
        $this->template->set_title('Dashboard');

        // Pass additional data to the view
        $data = array(
            'user_name' => $this->session->userdata('user_name')
        );
        
        // Render the dashboard view with the layout
        $this->template->render('brands/mails', $data);
    }
    public function api(){
        // Get the pagination parameters from the request (default values if not provided)
        $limit = $this->input->get('length'); // Number of records per page
        $offset = $this->input->get('start'); // Offset to fetch the data (skip this many records)
    
        // Fetch the paginated data from the model
        $leads = $this->Brand_model->get_brands($limit, $offset);
    
        // Get the total number of records (for pagination)
        $total_records = $this->Brand_model->get_total_brands_count();
    
        // Prepare the response data
        $response = array(
            'draw' => intval($this->input->get('draw')),  // DataTable draw counter
            'recordsTotal' => $total_records,  // Total records in the database
            'recordsFiltered' => $total_records,  // Records after filtering (for now we don't apply any filtering)
            'data' => $leads  // The paginated data
        );
    
        // Set the content type to JSON and output the data
        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
    }
    public function mail_api(){
        // Get the pagination parameters from the request (default values if not provided)
        $limit = $this->input->get('length'); // Number of records per page
        $offset = $this->input->get('start'); // Offset to fetch the data (skip this many records)
    
        // Fetch the paginated data from the model
        $leads = $this->Brand_model->get_emails($limit, $offset);
    
        // Get the total number of records (for pagination)
        $total_records = $this->Brand_model->get_total_emails_count();
    
        // Prepare the response data
        $response = array(
            'draw' => intval($this->input->get('draw')),  // DataTable draw counter
            'recordsTotal' => $total_records,  // Total records in the database
            'recordsFiltered' => $total_records,  // Records after filtering (for now we don't apply any filtering)
            'data' => $leads  // The paginated data
        );
    
        // Set the content type to JSON and output the data
        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
    }
    public function email_add(){
         // Set the page title
        $this->template->set_title('Dashboard');

        // Pass additional data to the view
        $data = array(
            'user_name' => $this->session->userdata('user_name')
        );
        
        // Render the dashboard view with the layout
        $this->template->render('brands/email_add', $data);
    }
    public function mailsave() {
        $data = [
            'MailUser' => $this->input->post('MailUser'),
            'MailPass' => $this->input->post('MailPass'),
            'MailServer' => $this->input->post('MailServer'),
            'MailStatus' => $this->input->post('MailStatus'),
            'MailCreatedAt' => $this->input->post('MailCreatedAt'),
            'MailCreatedBy' => $this->input->post('MailCreatedBy'),
        ];
    
        $this->db->insert('BrandEMails', $data); // Insert into DB
    
        redirect('brands/emails'); // Redirect to listing page
    }

}
?>