<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Api extends CI_Controller {

    public function __construct() {
        parent::__construct();
        // Load necessary helpers and libraries
        $this->load->helper('url');
        header('Access-Control-Allow-Origin: https://xyz.com');
        header('Access-Control-Allow-Origin: https://efg.com');
        header('Access-Control-Allow-Methods: POST');
        header('Access-Control-Allow-Headers: Content-Type, Authorization');
        $this->load->database();
    }

    // Endpoint to handle POST request and save data
    public function save_customer_data() {
        // Get the input data from the POST request
        $customer_name = $this->input->post('customer_name');
        $email = $this->input->post('email');
        $number = $this->input->post('number');
        $BrandID = $this->input->post('brandID');
        // Prepare data to be saved in the customer table
        $customer_data = array(
            'CustomerName' => $customer_name,
            'CustomerEmail' => $email,
            'CustomerNumber' => $number,
        );

        // Insert the customer data into the database
        $this->db->insert('customertable', $customer_data);

        // Get the last inserted ID (this is the customer ID)
        $customer_id = $this->db->insert_id();

        // Create LeadCode based on the saved customer ID
        $lead_code = 'LD-' . $customer_id;

        // Prepare data to be saved in the lead table
        $lead_data = array(
            'LeadCode' => $lead_code,
            'CustomerID' => $customer_id,
            'BrandID' => $BrandID, // Assuming brandID is 1, you can change this as required
            'CreateDate' => date('Y-m-d H:i:s'), // Current DateTime
            'Service' => 1, // You can modify this as per your needs
            'StatusID' => 22, // Assuming default status is 0
            'SourceID' => 1, // Assuming source is 1, you can modify this
            'AgentID' => 1, // Assuming agent is 1, you can modify this
            'Comments' => 'none', // Default comment
            'AgentName' => 'test', // Default agent name
            'PlaformID' => 1, // Assuming platformID is 1
        );

        // Insert the lead data into the lead table
        $this->db->insert('leadstable', $lead_data);
        echo $this->db->last_query();
        // Respond with success message (optional)
        echo json_encode(array('status' => 'success', 'message' => 'Data saved successfully'));
    }
}
